% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odmeans.R
\name{odmeans}
\alias{odmeans}
\title{ODMeans Function}
\usage{
odmeans(
  data,
  numKGlobal,
  limitSeparationGlobal,
  maxDistGlobal,
  distHierarchical,
  numKLocal,
  limitSeparationLocal,
  maxDistLocal,
  kmeans_pp = FALSE
)
}
\arguments{
\item{data}{A data frame with four columns:\cr
Initial Latitude | Initial Longitude | Final Latitude | Final Longitude}

\item{numKGlobal}{Initial number of clusters in the first call of k-means in the global hierarchy.}

\item{limitSeparationGlobal}{Within cluster distance threshold to determine if a global cluster must be separated into two new clusters.}

\item{maxDistGlobal}{Meter distance threshold used to re-estimate centroids in global hierarchy.}

\item{distHierarchical}{Meter distance threshold between origin and destination to generate new local clusters from a first layer cluster}

\item{numKLocal}{Initial number of clusters in the first call of k-means in the local hierarchy.}

\item{limitSeparationLocal}{Within cluster distance threshold to determine if a local cluster must be separated into two new clusters.}

\item{maxDistLocal}{Meter distance threshold used to re-estimate centroids in local hierarchy.}

\item{kmeans_pp}{Boolean value, if TRUE it initialize centroids using kmeans++.}
}
\value{
Returns an S3 class object similar to kmeans S3 Class, with eight properties.
}
\description{
ODMeans Function
}
\examples{
data(ODMeansTaxiData)
odmeans_data = odmeans(ODMeansTaxiData, 10, 300, 1000, 2200, 3, 50, 100)
}
