% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Accuracy.R
\name{Accuracy}
\alias{Accuracy}
\title{accuracy of oblique decision random forest}
\usage{
Accuracy(obj, data, newdata = NULL)
}
\arguments{
\item{obj}{An object of class \code{ODRF}, as that created by the function \code{\link{ODRF}}.}

\item{data}{Training data of class \code{data.frame} in \code{\link{ODRF}} is used to calculate the OOB error.}

\item{newdata}{A data frame or matrix containing new data is used to calculate the test error. If it is missing, then it is replaced by \code{data}.}
}
\value{
OOB error and test error, misclassification rate (MR) for classification or mean square error (MSE) for regression.
}
\description{
Prediction accuracy of ODRF at different tree sizes.
}
\examples{
data(breast_cancer)
set.seed(221212)
train <- sample(1:569, 80)
train_data <- data.frame(breast_cancer[train, -1])
test_data <- data.frame(breast_cancer[-train, -1])

forest <- ODRF(diagnosis ~ ., train_data,
  split = "gini",
  parallel = FALSE, ntrees = 50
)
(error <- Accuracy(forest, train_data, test_data))

}
\seealso{
\code{\link{ODRF}} \code{\link{VarImp}} \code{\link{plot.Accuracy}}
}
\keyword{forest}
