% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POO.R
\name{POO}
\alias{POO}
\title{Parallel Optimistic Optimization}
\usage{
POO(f, horizon = 100, noise.level, rhomax = 20, nu = 1)
}
\arguments{
\item{f}{function to maximize.}

\item{horizon}{maximum number of function evaluations.}

\item{noise.level}{scalar bound on the noise value.}

\item{rhomax}{number of equidistant \code{rho} values in [0,1], that are used by the corresponding HOO subroutines, see Details.}

\item{nu}{scalar (> 0) assessing the complexity of the function, along with \code{rho} (see the near optimality definition in the reference below).}
}
\value{
Random point evaluated by the best HOO, in the form of a list with elements:
\itemize{
 \item par parameter value at this point,
 \item value noisy value at \code{par},
 \item best_rho best \code{rho} value.
}
}
\description{
Global optimization of a blackbox function given a finite budget of noisy evaluations,
via the Parallel Optimistic Optimization algorithm.
The knowledge of the function's smoothness is not required.
}
\details{
Only 1-dimensional functions defined on [0, 1] are handled so far.
POO uses Hierarchical Optimistic Optimisation (HOO) as a subroutine, whose number is set by \code{rhomax}.
\code{POO} handles more difficult functions than \code{\link[OOR]{StoSOO}}.
}
\examples{
\dontrun{
#------------------------------------------------------------
# Maximization with POO
#------------------------------------------------------------
set.seed(10)
noise.level <- 0.05

## Define and display objective
ftest <- function(x){return(double_sine(x) + runif(1, min = -noise.level, max = noise.level))}
xgrid <- seq(0, 1, length.out = 1000)
plot(xgrid, sapply(xgrid, double_sine), type = 'l', ylab = "double_sine(x)", xlab = 'x')

## Optimization
Sol <- POO(ftest, horizon = 1000, noise.level = noise.level)

## Display result
abline(v = Sol$par)
}
}
\references{
J.-B. Grill, M. Valko and R. Munos (2015), Black-box optimization of noisy functions with unknown smoothness,
  \emph{NIPS}, 667-675 \url{https://inria.hal.science/hal-01222915}. Python code: \url{https://team.inria.fr/sequel/software/POO/}.
}
\author{
M. Binois (translation in R code), J.-B. Grill, M. Valko and R. Munos (Python code)
}
