% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPTtesting.R
\name{Optimal_procedure_3}
\alias{Optimal_procedure_3}
\title{Optimal_procedure_3}
\usage{
Optimal_procedure_3(prob_0, alpha)
}
\arguments{
\item{prob_0}{d-values or l-values}

\item{alpha}{significance level}
}
\value{
ai: a vector of decisions. (1 indicates rejection)

cj: The number of rejections

FDR_hat: The estimated false discovery rate (FDR).

FNR_hat: The estimated false non-discovery rate (FNR).
}
\description{
decision process
}
\examples{
prob = runif(100,0,1) #assume this is the posterior probability vector
level = 0.3 #the significance level
Optimal_procedure_3(prob,level)
\donttest{
library(MASS)
######################################
#construct a test statistic vector Z
p = 1000
n_col = 4
pi_0 = 0.6
pi_1 = 0.2
pi_2 = 0.2
nu_0 = 0
mu_1 = -1.5
mu_2 = 1.5
tau_sqr_1 = 0.1
tau_sqr_2 = 0.1


A = matrix(rnorm(p*n_col,0,1), nrow = p, ncol = n_col, byrow = TRUE)
Sigma = A \%*\% t(A) +diag(p)
Sigma = cov2cor(Sigma) #covariance matrix




b = rmultinom(p, size = 1, prob = c(pi_0,pi_1,pi_2))
ui = b[1,]*nu_0 + b[2,]*rnorm(p, mean = mu_1,
     sd = sqrt(tau_sqr_1)) + b[3,]*rnorm(p, mean = mu_2,
      sd = sqrt(tau_sqr_2)) # actual situation
Z = mvrnorm(n = 1,ui, Sigma, tol = 1e-6, empirical = FALSE, EISPACK = FALSE)

prob_p = d_value(Z,Sigma)
#decision
level = 0.1 #significance level
decision_p = Optimal_procedure_3(prob_p,level)
decision_p$cj
head(decision_p$ai)
}
}
