# Module: DStar
#
# Modules to manage conditional residuals for ordinal variables
#
#
# @param  y is a vector generated by \code{ExpandY} function
# @param  L is \code{max}(y), y=0,1,...,L.
#
# @return a vector Y**, see Heagerty and Zeger (1996).



DStar<-function(y,L){
  obs<-length(y)/L
  for (k in 1:(obs-1)) {
    a<-y[(k*L+1):(obs*L)]
    b<-c()
    d<-c()
    for (j in 0:(length(a)/L-1)) {
      d<-kronecker(rep(1,L),data.matrix(a[(j*L+1):((j+1)*L)]))
      if (j==0){b<-d}else{b<-c(b,d)}
    }
    if (k==1){o<-b}else{o<-c(o,b)}
  }
  return(o)
}

