% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCVgeneral.R
\name{C_smooth}
\alias{C_smooth}
\title{The OSCV smooth rescaling constant.}
\usage{
C_smooth(alpha, sigma)
}
\arguments{
\item{alpha}{first parameter of the two-sided cross-validation kernel \code{\link{H_I}},}

\item{sigma}{second parameter of the two-sided cross-validation kernel \code{\link{H_I}}.}
}
\value{
The OSCV smooth rescaling constant \eqn{C} for the given values of the parameters \eqn{\alpha} and \eqn{\sigma}.
}
\description{
Computing the OSCV smooth rescaling constant that corresponds to using the two-sided kernel \code{\link{H_I}} for the cross-validation purposes and the Gaussian kernel in the estimation stage. The constant is applicable for the OSCV versions in the regression and kernel density estimation contexts.
}
\details{
Computation of the OSCV rescaling constant \eqn{C} (see (10) in Savchuk and Hart (2017) or (3) in Savchuk (2017)). The constant is a function of the parameters \eqn{(\alpha,\sigma)} of the two-sided cross-validation kernel \code{\link{H_I}} defined by expression (15) in Savchuk and Hart (2017). The Gaussian kernel is used for computing the ultimate (regression or density) estimate. The constant is used in the OSCV versions for kernel regression and density estimation. Notice that in the cases \eqn{\alpha=0}, \eqn{\sigma>0} and \eqn{\sigma=1}, \eqn{-\infty<\alpha<\infty} the kernel \code{\link{H_I}} reduces to the Gaussian kernel.
}
\examples{
# OSCV rescaling constant for the robust cross-validation kernel with 
# (alpha,sigma)=(16.8954588,1.01).
C_smooth(16.8954588,1.01)
# OSCV smooth rescaling constant in the case when the kernel H_I is Gaussian.
C_smooth(1,1)
}
\references{
\itemize{
  \item Savchuk, O.Y., Hart, J.D. (2017). Fully robust one-sided cross-validation for regression functions. \emph{Computational Statistics}, doi:10.1007/s00180-017-0713-7.
  \item Savchuk, O.Y. (2017). One-sided cross-validation for nonsmooth density functions, arXiv:1703.05157.
}
}
\seealso{
\code{\link{L_I}}, \code{\link{H_I}}, \code{\link{OSCV_reg}}, \code{\link{h_OSCV_reg}}, \code{\link{OSCV_LI_dens}}, \code{\link{OSCV_Gauss_dens}}, \code{\link{h_OSCV_dens}}, \code{\link{loclin}}.
}
