% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_density.R
\name{sample_fstar}
\alias{sample_fstar}
\title{Taking a random sample from \code{\link{fstar}}.}
\usage{
sample_fstar(n)
}
\arguments{
\item{n}{sample size.}
}
\value{
The numerical vector of size \eqn{n} of the data values.
}
\description{
Taking a random sample of size \eqn{n} from the density \eqn{f^*} with seven cusps introduced in the article of Savchuk (2017).
}
\details{
The density \eqn{f^*} can be used in simulation studies.
}
\examples{
\dontrun{
dev.new()
plot(density(sample_fstar(5000),bw=0.1),lwd=2,ylim=c(0,0.32),xlab="argument",ylab="density",
main="KDE and the true density fstar",cex.lab=1.7, cex.axis=1.7,cex.main=1.7)
lines(seq(-3.5,3.5,len=1000),fstar(seq(-3.5,3.5,len=1000)),lwd=3,lty="dashed")
legend(-3,0.3,legend=c("KDE","True density","h=0.1","n=5000"),lwd=c(2,3),
lty=c("solid","dashed"),col=c("black","black","white","white"))
}
}
\references{
Savchuk, O.Y. (2017). One-sided cross-validation for nonsmooth density functions, arXiv:1703.05157.
}
\seealso{
\code{\link{fstar}}, \code{\link{ISE_fstar}}.
}
