% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoFunctions.R
\name{distcenter}
\alias{distcenter}
\title{A function to compute the distance from spatial units centroids 
to the center}
\usage{
distcenter(spatobj = NULL, folder = NULL, shape = NULL, 
center = 1, distin = 'm',  distout = 'm')
}
\arguments{
\item{spatobj}{a spatial object (class sf, sfc or sfg) containing 
geographic information}

\item{folder}{a character vector with the folder (directory) 
name indicating where the shapefile with the geographic information 
is located.}

\item{shape}{a character vector with the name of the shapefile 
(without the .shp extension) which contains the geographic information}

\item{center}{the row number of the center}

\item{distin}{input metric conversion, based on  \pkg{measurements} package and 
includes conversions from 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{distout}{output metric conversion, based on  \pkg{measurements} package and 
includes conversions to 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}
}
\value{
A vector with the distance to the center's centroid
}
\description{
The function is based on \pkg{sf} 
package and it can be used with a shape file or an R 
spatial object (class sf, sfc or sfg).
}
\examples{
distcenter(segdata, center = 46) 
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'
distcenter(folder = foldername, shape = shapename, center = 19)
}
\seealso{
Other spatial functions used for segregation indices 
computation: \code{\link{area}}, \code{\link{contig}}, 
\code{\link{perimeter}}, \code{\link{distance}}, 
\code{\link{boundaries}}
}
