\name{fmr}
\title{Fit a Generalized Nonlinear Regression Model with a Two
Point Mixture}
\usage{
fmr(y, dist="normal", pmu=NULL, pshape=NULL, pmix=NULL, mu=NULL,
	mix=NULL, linear=NULL, censor="right", exact=F, wt=1, delta=1,
	print.level=0, typsiz=abs(p), ndigit=10, gradtol=0.00001,
	stepmax=10*sqrt(p\%*\%p), steptol=0.00001, iterlim=100, fscale=1)
}
\alias{fmr}
\alias{coefficients.fmr}
\alias{deviance.fmr}
\alias{df.residual.fmr}
\alias{fitted.values.fmr}
\alias{residuals.fmr}
\alias{weights.fmr}
\arguments{
\item{y}{The response vector for Poisson and negative binomial
distributions or a two column matrix for (beta) binomial data. For
censored data, two columns with the second being the censoring
indicator (1: uncensored, 0: right censored, -1: left censored.)
It may also be an object of class, response.}
\item{dist}{Either a character string containing the name of the
distribution or a function giving the -log likelihood and calling the
location and mixture functions.}
\item{pmu}{Vector of initial estimates for the location parameters.}
\item{pshape}{Initial estimate for the shape parameter.}
\item{pmix}{Vector of initial estimates for the mixture parameters.}
\item{mu}{User-specified function of \code{p}, and possibly linear,
giving the regression equation for the location. This may contain a
linear part that must simply be given the name, linear, in the
function. It may also be a language expression beginning with ~,
specifying a linear regression function for the location parameter.
If neither is supplied, the location is taken to be constant unless
the linear argument is given.}
\item{mix}{User-specified function of \code{p}, and possibly linear,
giving the regression equation for the mixture parameter. This may
contain a linear part that must simply be given the name, linear, in
the function. It may also be a language expression beginning with ~,
specifying a linear regression function for the mixture parameter. If
no function is supplied, this parameter is taken to be constant. This
parameter is the logit of the mixture probability.}
\item{linear}{Language expression beginning with ~, or list of two
such expressions, specifying the linear part of the regression
function for the location or location and mixture parameters.}
\item{censor}{\code{right}, \code{left}, or \code{both} indicating
where the mixing distribution is placed. \code{both} is only possible
for binomial data.}
\item{exact}{If TRUE, fits the exact likelihood function for
continuous data by integration over intervals of observation,
i.e. interval censoring.}
\item{wt}{Weight vector.}
\item{delta}{Scalar or vector giving the unit of measurement (always
one for discrete data) for each response value, set to unity by
default - for example, if a response is measured to two decimals,
delta=0.01. If the response is transformed, this must be multiplied by
the Jacobian. The transformation cannot contain unknown parameters.
For example, with a log transformation, \code{delta=1/y}.}
\item{others}{Arguments controlling \code{\link{nlm}}.}
}
\description{
\code{fmr} fits user specified nonlinear regression equations to the
location parameter of the common one and two parameter distributions
(binomial, beta binomial, double binomial, multiplicative binomial,
Poisson, negative binomial, double Poisson, multiplicative Poisson,
gamma count, Consul, geometric, normal, inverse Gauss, logistic,
exponential, gamma, Weibull, extreme value, Pareto, Cauchy, Student t,
Laplace, and Levy). For the Poisson and negative binomial, the mixture
involves the zero category. For the (beta) binomial, it involves the
two extreme categories. For all other distributions, it involves
either left or right censored individuals. A user-specified -log
likelihood can also be supplied for the distribution.
}
\value{
A list of class gnlr is returned.
The printed output includes the -log likelihood (not the deviance),
the corresponding AIC, the maximum likelihood estimates, standard
errors, and correlations. A list is returned that contains all of the
relevant information calculated, including error codes.
}
\seealso{
\code{\link{lm}}, \code{\link{glm}}, \code{\link{gnlr}}, \code{\link{gnlr3}}.
}
\examples{
# linear regression with inverse Gauss distribution with a point mass
# for right censored individuals
mu <- function(p) p[1]+p[2]*sex+p[3]*age
fmr(data, dist="inverse Gauss", pmu=rep(1,3), pmix=1, mu=mu)
# or equivalently
fmr(data, dist="inverse Gauss", pmu=rep(1,3), pmix=1, mu=~sex+age)
# or
fmr(data, dist="inverse Gauss", pmu=rep(1,3), pmix=1, linear=~sex+age)
#
# nonlinear regression with inverse Gauss distribution
mu <- function(p, linear) p[4]*exp(linear)
fmr(data, dist="inverse Gauss", pmu=rep(1,4), pmix=1, mu=mu,
	linear=~sex+age)
#
# include logistic regression for the mixture parameter with
# same mu function
mix <- function(p) p[5]+p[6]*sex+p[7]*age
fmr(data, dist="inverse Gauss", pmu=rep(1,4), pmix=rep(1,3), mu=mu,
	mix=mix)
# or equivalently
fmr(data, dist="inverse Gauss", pmu=rep(1,4), pmix=rep(1,3), mu=mu,
	linear=list(~sex+age,~sex+age))
}
