\name{nordr}
\title{Nonlinear Ordinal Regression}
\usage{
nordr(y, dist="proportional", mu, linear=NULL, pmu, 
pintercept, wt=NULL, print.level=0, ndigit=10, gradtol=0.00001,
steptol=0.00001, fscale=1, iterlim=100, typsiz=abs(p),
stepmax=10*sqrt(p\%*\%p))
}
\arguments{
\item{y}{A vector of ordinal responses, integers numbered from one to
the maximum value.}
\item{dist}{The ordinal distribution: proportional odds, continuation
ratio, or adjacent categories.}
\item{mu}{User-specified function of \code{pmu}, and possibly \code{linear},
giving the logistic regression equation. This must contain the first
intercept. It may contain a linear part as the second argument to the
function. It may also be a language expression beginning with ~,
specifying a logistic regression function for the location
parameter. If neither is supplied, the location is taken to be
constant unless the linear argument is given.}
\item{linear}{Language expression beginning with ~, specifying the
linear part of the logistic regression function.}
\item{pmu}{Vector of initial estimates for the regression parameters.}
\item{pintercept}{Vector of initial estimates for the contrasts with
the first intercept parameter (difference in intercept for successive
categories): two less than the number of different ordinal values.}
\item{wt}{Weight vector for use with contingency tables.}
\item{others}{Arguments controlling \code{\link{nlm}}.}
}
\description{
\code{nordr} fits arbitrary nonlinear regression functions (with
logistic link) to ordinal response data by proportional odds,
continuation ratio, or adjacent categories.
}
\value{
A list of class nordr is returned.
The printed output includes the -log likelihood (not the deviance),
the corresponding AIC, the maximum likelihood estimates, standard
errors, and correlations. A list is returned that contains all of the
relevant information calculated, including error codes.
}
\seealso{
\code{\link{lm}}, \code{\link{glm}}, \code{\link{glmm}},
\code{\link{gnlmm}}, \code{\link{gnlr}}, \code{\link{gnlr3}},
\code{\link{fmr}, \code{\link{nlr}}.
}
\examples{
# McCullagh (1980) JRSS B42, 109-142
# Tonsil size: 2x3 contingency table
y <- c(1:3,1:3)
carrier <- gl(2,3,6)
wt <- c(19,29,24,497,560,269)
pmu <- c(-1,0.5)
mu <- function(p) c(rep(p[1],3),rep(p[1]+p[2],3))
# proportional odds with mean function
nordr(y, dist="prop", mu=mu, pmu=pmu, wt=wt, pbl=1.5)
# proportional odds using Wilkinson and Rogers notation
nordr(y, dist="prop", mu=~carrier, pmu=pmu, wt=wt, pbl=1.5)
# continuation ratio
nordr(y, dist="cont", mu=mu, pmu=pmu, wt=wt, pbl=1.5)
# adjacent categories
nordr(y, dist="adj", mu=~carrier, pmu=pmu, wt=wt, pbl=1.5)
}
