\name{plot.residuals}
\title{Plot Residuals}
\usage{
plot.residuals(z, x=NULL, subset=NULL, ccov=NULL, nind=NULL,
	recursive=TRUE, pch=20, ylab="Residual", xlab=NULL,
	main=NULL, ...)
}
\alias{plot.residuals}
\arguments{
\item{z}{An object of class recursive, from \code{\link{carma}},
\code{\link{gar}}, \code{\link{kalcount}}, \code{\link{kalseries}},
\code{\link{kalsurv}}, or \code{\link{nbkal}}.}
\item{x}{Vector of of values for the x-axis. If missing, time is
used. It can also be specified by the strings "response" or "fitted".}
\item{subset}{A logical vector defining which observations are to be
used.}
\item{ccov}{If the index number of a time-constant covariate is
supplied, separate plots are made for each distinct value of that
covariate.}
\item{nind}{Observation number(s) of individual(s) to be plotted.}
\item{recursive}{If TRUE, plot recursive residuals, otherwise ordinary
residuals.}
\item{others}{Plotting control options.}
}
\value{
\code{plot.residuals} is used for plotting residuals from models
obtained from Kalman fitting for given subsets of the data.
}
\seealso{
\code{\link{carma}}, \code{\link{gar}}, \code{\link{kalcount}},
\code{\link{kalseries}}, \code{\link{kalsurv}}, \code{\link{nbkal}}
\code{\link{plot.iprofile}}, \code{\link{plot.profile}}.
}
\examples{
mu <- function(p) exp(p[1]-p[3])*(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*tt)-exp(-exp(p[1])*tt)))
shape <- function(p) exp(p[1]-p[2])*tt*dose*exp(-exp(p[1])*tt)
z <- gar(conc, dist="gamma", times, censor=censor, mu=mu, shape=shape,
	preg=c(0.89,-0.77,4), pdep=0.4, psh=c(-1.5,1.17), delta=0.01))
plot.residuals(z, subset=433:648, ylim=c(-2,2), main="Dose 150")
plot.residuals(z, x="predicted", subset=433:648, ylim=c(-2,2),
	main="Dose 150")
plot.residuals(z, x="response", subset=433:648, ylim=c(-2,2),
	main="Dose 150")
}
