\name{restovec}
\title{Create a response object}
\usage{
restovec(response, times=NULL, totals=NULL, nest=NULL, censor=NULL,
delta=NULL)
}
\alias{restovec}
\alias{print.response}
\alias{plot.response}
\arguments{
\item{response}{A matrix or dataframe of response values, a list of
vectors of event histories, or a list of one or more column matrices,
for each individual, with response values in the first column and
times in the second, possibly followed by columns with binomial
totals, nesting categories, censoring indicators, and/or units of
measurement.}
\item{times}{When response is a matrix, a vector of possibly unequally
spaced times when they are the same for all individuals or a matrix of
times. Not necessary if equally spaced.}
\item{totals}{If the response is a matrix of binomial counts, a
corresponding vector (one total or one per individual) or matrix of totals.}
\item{nest}{When \code{response} is a matrix, a vector of length equal
to the number of responses per individual indicating which responses
belong to which nesting category. Values must be consecutive increasing
integers.}
\item{censor}{A vector of the same length as the number of individuals
containing a binary indicator, with a one indicating that the last
time period in the series terminated with an event and zero that it
was censored, or, when response is matrix, a matrix of the same size.
For event history data, even with no censoring, an appropriate vector
of ones must be supplied.}
\item{delta}{The unit of measurement (if not equal to unity), a scalar
or a vector.}
}
\description{
\code{restovec} transforms a list of vectors of event histories or of
two or more column matrices with times, response values, and possibly
binomial totals, nesting categories, censor indicators, and/or units of
measurement, for each individual, or a matrix or dataframe of response
values into an object of class, response.

Such objects can be printed and plotted. NAs are removed with
\code{rmna} (where necessary, incoordination with the appropriate
covariates).
}
\value{
Returns an object of class, response, containing a vector with the
responses (z$y), a corresponding vector of times (z$times), a vector
giving the number of observations per individual (z$nobs), and
possibly binomial totals (z$n), nesting (clustering, z$nest),
censoring (z$censor), and unit of measurement information (z$delta).
}
\seealso{
\code{\link{carma}}, \code{\link{elliptic}}, \code{\link{gettvc}},
\code{\link{kalcount}}, \code{\link{kalseries}}, \code{\link{nbkal}},
\code{\link{read.list}}, \code{\link{tcctomat}}, \code{\link{tvctomat}}.
}
