% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity_plot.R
\name{diversity_plot}
\alias{diversity_plot}
\title{Diversity plot}
\usage{
diversity_plot(
  data,
  values,
  col_name,
  group_by = NULL,
  palette,
  method,
  paired = FALSE,
  p.adjust.method = "fdr"
)
}
\arguments{
\item{data}{A \link[base]{data.frame} or \link[data.table]{data.table} computed from \link{diversity}.}

\item{values}{A column name of a continuous variable.}

\item{col_name}{A column name of a categorical variable.}

\item{group_by}{A column name to perform grouped statistical test (default: NULL).}

\item{palette}{An object with names and hexcode or color names, see \link{colormap}.}

\item{method}{A character variable indicating what method is used to compute the diversity.}

\item{paired}{A boolean value to perform paired analysis in \link[stats]{wilcox.test}.}

\item{p.adjust.method}{A character variable to specify the p.adjust.method to be used (Default: fdr).}
}
\value{
A \link[ggplot2]{ggplot2} object to be further modified
}
\description{
Creates an Alpha diversity plot. This function is built into the class \link{omics} with method \code{alpha_diversity()}.
It computes the pairwise wilcox test, paired or non-paired, given a data frame and adds useful labelling.
}
\examples{
library("ggplot2")
 
n_row <- 1000
n_col <- 100
density <- 0.2
num_entries <- n_row * n_col
num_nonzero <- round(num_entries * density)

set.seed(123)
positions <- sample(num_entries, num_nonzero, replace=FALSE)
row_idx <- ((positions - 1) \%\% n_row) + 1
col_idx <- ((positions - 1) \%/\% n_row) + 1

values <- runif(num_nonzero, min = 0, max = 1)
sparse_mat <- Matrix::sparseMatrix(
   i = row_idx,
   j = col_idx,
   x = values,
   dims = c(n_row, n_col)
 )

div <- OmicFlow::diversity(
  x = sparse_mat,
  metric = "shannon"
)

dt <- data.table::data.table(
  "shannon" = div,
  "treatment" = c(rep("healthy", n_col / 2), rep("tumor", n_col / 2))
)

colors <- OmicFlow::colormap(dt, "treatment")

plt <- OmicFlow::diversity_plot(
 data = dt,
 values = "shannon",
 col_name = "treatment",
 palette = colors,
 method = "shannon",
 paired = FALSE,
 p.adjust.method = "fdr"
)
}
