% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpeNoise.R
\name{AcousticQuantilePlot}
\alias{AcousticQuantilePlot}
\title{Plot acoustic quantile}
\usage{
AcousticQuantilePlot(df, Cols, Quantile, TimeZone = "UTC")
}
\arguments{
\item{df}{is a dataframe}

\item{Cols}{vector of index cols (1/3 band frequency)}

\item{Quantile}{quantile, for example 0.95}

\item{TimeZone}{Time zone dataset (default is UTC)}
}
\value{
an OpeNoise object of class ggplot
}
\description{
Returns a plot of acoustic quantile of 1/3 band frequency
}
\examples{
# Plot reverse quantile of 1/3 band frequency

library(lubridate)

datasetI <- dataset_impulsive1
datasetH <- dfImpulsiveTrasform(datasetI)

AcousticQuantilePlot(df = datasetH, Cols =c(3:38), Quantile = 0.95,
                     TimeZone = "UTC")
}
\author{
Pasquale Scordino \email{p.scordino@arpa.piemonte.it}

Simone Sperotto \email{s.sperotto@arpa.piemonte.it}
}
