% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-openrepgrid.r
\docType{data}
\name{df_element_columns}
\alias{df_element_columns}
\title{Sample dataframe with grid data (elements are columns)}
\description{
This dataframe can be converted into a \code{repgrid} object via \code{\link[=importDataframe]{importDataframe()}}. The dataframe column names are the
minimum of the rating scale (\code{1}), the element names (\code{element_1} to \code{element_4}), the maximum of the rating scale
(\code{5}), and optionally a column indicating the \code{preferred} pole. Each row contains the constructs' entries (left
pole, ratings, right pole, preferred pole). The preferred pole must be one of \code{left}, \code{right}, \code{none}, \code{NA} (see
\code{\link[=preferredPoles]{preferredPoles()}}). See sample data \link{df_element_columns}.
}
\details{
\tabular{lccccrr}{
\code{1}           \tab \code{element_1} \tab \code{element_2} \tab \code{element_3} \tab \code{element_4} \tab \code{5}            \tab \code{preferred} \cr
\code{left_pole_1} \tab \code{1}         \tab \code{5}         \tab \code{3}         \tab \code{4}         \tab \code{right_pole_1} \tab \code{left}      \cr
\code{left_pole_2} \tab \code{3}         \tab \code{1}         \tab \code{1}         \tab \code{3}         \tab \code{right_pole_2} \tab \code{right}     \cr
\code{left_pole_3} \tab \code{4}         \tab \code{2}         \tab \code{5}         \tab \code{1}         \tab \code{right_pole_3} \tab \code{none}        \cr
}
}
\examples{
df_element_columns
importDataframe(df_element_columns)
}
\seealso{
\code{\link[=importDataframe]{importDataframe()}}

Other grid dataframes: 
\code{\link{df_construct_columns}},
\code{\link{df_long}}
}
\concept{grid_dataframe}
\keyword{data}
