% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.r
\name{plot.indexDilemma}
\alias{plot.indexDilemma}
\title{Plot method for indexDilemma (network graph)}
\usage{
\method{plot}{indexDilemma}(
  x,
  layout = "rows",
  both.poles = TRUE,
  node.size = 50,
  node.text.cex = 1,
  node.label.color = "black",
  node.color.discrepant = "darkolivegreen3",
  node.color.congruent = "lightcoral",
  edge.label.color = grey(0.4),
  edge.label.cex = 1,
  edge.digits = 2,
  edge.arrow.size = 0.5,
  edge.color = grey(0.6),
  edge.lty = 2,
  ...
)
}
\arguments{
\item{x}{Object returned by \code{indexDilemma}.}

\item{layout}{Name of layout. One of \code{rows}, \code{circle}, \code{star}, or \code{nicely} or a
\code{igraph} layout function.}

\item{both.poles}{Show both construct poles? (default \code{TRUE}). If \code{FALSE}
only the poles corresponding to the implied undesired changes are shown.}

\item{node.size}{Size of nodes (default \code{50}).}

\item{node.text.cex}{Text size of construct labels.}

\item{node.label.color}{Color of construct labels.}

\item{node.color.discrepant, node.color.congruent}{Color of discrepant and congruent constructs nodes.}

\item{edge.label.color, edge.label.cex}{Color and size of correlation labels.}

\item{edge.color, edge.arrow.size}{Color and Size of arrow.}

\item{edge.lty}{Linetype of arrow.}

\item{digits}{Number of digits for correlations.}
}
\description{
Produces a network graph using of the detected implicative dilemmas using the
\code{igraph} package.
}
\keyword{internal}
