% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obwoe.R
\name{summary.obwoe}
\alias{summary.obwoe}
\title{Summary Method for obwoe Objects}
\usage{
\method{summary}{obwoe}(object, sort_by = "iv", decreasing = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{"obwoe"}.}

\item{sort_by}{Character string specifying the column to sort by.
Options: \code{"iv"} (default), \code{"n_bins"}, \code{"feature"}.}

\item{decreasing}{Logical. Sort in decreasing order? Default is \code{TRUE}
for IV, \code{FALSE} for feature names.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
An S3 object of class \code{"summary.obwoe"} containing:
\describe{
  \item{\code{feature_summary}}{Data frame with per-feature statistics including
    IV classification (Unpredictive/Weak/Medium/Strong/Suspicious)}
  \item{\code{aggregate}}{Named list of aggregate statistics:
    \describe{
      \item{\code{n_features}}{Total features processed}
      \item{\code{n_successful}}{Features without errors}
      \item{\code{n_errors}}{Features with errors}
      \item{\code{total_iv_sum}}{Sum of all feature IVs}
      \item{\code{mean_iv}}{Mean IV across features}
      \item{\code{median_iv}}{Median IV across features}
      \item{\code{mean_bins}}{Mean number of bins}
      \item{\code{iv_range}}{Min and max IV values}
    }
  }
  \item{\code{iv_distribution}}{Table of IV classification counts}
  \item{\code{target}}{Target column name}
  \item{\code{target_type}}{Target type (binary/multinomial)}
}
}
\description{
Generates comprehensive summary statistics for optimal binning results,
including predictive power classification based on established IV thresholds
(Siddiqi, 2006), aggregate metrics, and feature-level diagnostics.
}
\details{
\subsection{IV Classification Thresholds}{

Following Siddiqi (2006), features are classified by predictive power:

\tabular{ll}{
  \strong{Classification} \tab \strong{IV Range} \cr
  Unpredictive \tab < 0.02 \cr
  Weak \tab 0.02 - 0.10 \cr
  Medium \tab 0.10 - 0.30 \cr
  Strong \tab 0.30 - 0.50 \cr
  Suspicious \tab > 0.50
}

Features with IV > 0.50 should be examined for data leakage or
overfitting, as such high values are rarely observed in practice.
}
}
\examples{
\donttest{
set.seed(42)
df <- data.frame(
  x1 = rnorm(500), x2 = rnorm(500), x3 = rnorm(500),
  target = rbinom(500, 1, 0.2)
)
result <- obwoe(df, target = "target")
summary(result)
}

}
\references{
Siddiqi, N. (2006). Credit Risk Scorecards: Developing and Implementing
Intelligent Credit Scoring. \emph{John Wiley & Sons}.
\doi{10.1002/9781119201731}
}
\seealso{
\code{\link{obwoe}} for the main binning function,
  \code{\link{print.obwoe}}, \code{\link{plot.obwoe}}.
}
