% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgb2spLayout.R
\name{rgb2spLayout}
\alias{rgb2spLayout}
\title{Convert an RGB \verb{Raster*} to Use with \code{spplot()}}
\usage{
rgb2spLayout(x, quantiles = c(0.02, 0.98), alpha = 1)
}
\arguments{
\item{x}{A 3-layered \verb{SpatRaster*} or \verb{Raster*} object.}

\item{quantiles}{Upper and lower quantiles used for color stretching.}

\item{alpha}{Level of transparency.}
}
\description{
This function takes a red-green-blue \code{SpatRaster} or \verb{Raster*} object and
produces a list with color information that can be passed on as 'sp.layout'
to \code{\link[sp:spplot]{sp::spplot()}}.
}
\examples{
b = terra::rast(system.file("ex/logo.tif", package="terra"))

## using plotRGB
terra::plotRGB(b)

## convert raster to list
lout = rgb2spLayout(b)
lout_alph = rgb2spLayout(b, alpha = 0.5)

## create random spatial points for plotting
df = data.frame(
  dat = rnorm(100, 2, 1)
  , x = rnorm(100, 50, 20)
  , y = rnorm(100, 50, 25)
)

df = sf::st_as_sf(df, coords = c("x", "y"))

## plot spatial points with rgb background
if (require(sp, quietly = TRUE)) {
  spplot(as(df, "Spatial"), sp.layout = lout)
  spplot(as(df, "Spatial"), sp.layout = lout_alph)
}

}
\seealso{
\code{\link[terra:plotRGB]{terra::plotRGB()}}.
}
\author{
Tim Appelhans, Florian Detsch
}
