% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssnma.R
\name{ssnma}
\alias{ssnma}
\title{Calculate the optimal sample sizes for a new two-arm trial when analyze it with the existing network}
\usage{
ssnma(
  p1,
  p2,
  enma_sigma = NULL,
  power.level,
  sig.level = 0.05,
  method = "with",
  allocation = "uneven"
)
}
\arguments{
\item{p1}{Risk of treatment 1}

\item{p2}{Risk of treatment 2}

\item{enma_sigma}{Standard error of the estimated effect size (log odds ratio) between treatment 1 and treatment 2 from the existing network}

\item{power.level}{Power of test we want to obtain}

\item{sig.level}{Significance level, the default value is 0.05}

\item{method}{a character string specifying the method of analyzing the new trial, must be one of 'with' (default) or 'without'}

\item{allocation}{a character string specifying the type of sample size allocation between two groups, must be one of 'uneven' (default) or 'even'.}
}
\value{
A list with the following components:
\item{sample_size}{Sample size for each treatment group.}
\item{power}{Power of the test.}
}
\description{
This function calculates the optimal sample size for each treatment group to
achieve a pre-specified power when planning a new two-arm trial with
binary outcome.
}
\examples{
ssnma(p1 = 0.2, p2 = 0.3, enma_sigma = 0.4, power = 0.8)
}
