% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_generate_report}
\alias{f_generate_report}
\title{Generate PDF Report for a PERSUADE Analysis}
\usage{
f_generate_report(
  PERSUADE,
  output_dir = NULL,
  template_dir = NULL,
  open = FALSE
)
}
\arguments{
\item{PERSUADE}{A PERSUADE object returned by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}

\item{output_dir}{Character string giving the directory to copy the function
output to. If \code{NULL} (the default), the function uses:
\code{file.path(tempdir(), paste0(PERSUADE$name, "_output"))}. Change \code{tempdir()}
into \code{getwd()} for copying to working directory.}

\item{template_dir}{Optional character string giving the full path to an Rmd
template. If \code{NULL} (the default), the function looks for
\code{PERSUADE_output.Rmd} within the package installation directory.}

\item{open}{Logical. Whether to browse the generated file.}
}
\value{
A length-1 character string giving the absolute path to the generated
PDF, returned invisibly.
}
\description{
Save the PERSUADE object and render a PDF report using the bundled
\code{PERSUADE_output.Rmd} template, or a user-specified template.
}
\details{
The default R markdown file \code{PERSUADE_output.Rmd} is stored within
the package under \verb{inst/rmd/}. Figures are written to a subdirectory
\verb{Images/} inside the output folder, and the knit environment is
initialised with the supplied \code{PERSUADE} object. Supplying a custom
\code{template_dir} allows alternative report formats to be used, and
simplifies testing. This function requires the following suggested packages:
\pkg{knitr}, \pkg{kableExtra}, and \pkg{rmarkdown}.
If not installed, the function will throw an error.
}
\examples{
\dontrun{ # Requires LaTeX to be installed
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
# Copy output to temporary directory
# (change `tempdir()` into `getwd()`
# for copying to working directory)
f_generate_report(
  PERSUADE,
  output_dir = file.path(
  tempdir(), paste0(PERSUADE$name, "_output")
  ),
  template_dir = NULL
)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
