% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfw_species.R
\name{pfw_species}
\alias{pfw_species}
\title{Filter Project FeederWatch Data by Species}
\usage{
pfw_species(data, species, suppress_ambiguous = FALSE)
}
\arguments{
\item{data}{The Project FeederWatch dataset.}

\item{species}{A character vector of species names (common, scientific, or six-letter species code).}

\item{suppress_ambiguous}{(Optional, default = FALSE) TRUE/FALSE on including missing subspecies in the warning. This is just a silencer for the pfw_filter function.}
}
\value{
A filtered dataset containing only the selected species.
}
\description{
This function filters Project FeederWatch data to include only selected species, with common names
or scientific names via the species translation table.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Download/load example dataset
data <- pfw_example

# Filter for only Greater Roadrunner using the common name
data_GRRO <- pfw_species(data, "Greater Roadrunner")

# Filter for Lesser Goldfinch and American Goldfinch using scientific names
data_goldfinches <- pfw_species(data, c("Spinus psaltria", "Spinus tristis"))

# Filter for Dark-eyed Junco, Song Sparrow, and Spotted Towhee using species codes
data_masonsyard <- pfw_species(data, c("daejun", "sonspa", "spotow"))

# Filter with a pre-existing species list
species_list <- c("daejun", "sonspa", "spotow")
data_masonsyard <- pfw_species(data, species_list)
\dontshow{\}) # examplesIf}
}
