% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfw_zerofill.R
\name{pfw_zerofill}
\alias{pfw_zerofill}
\title{Zerofill Species not Detected in each Survey Instance for Analysis}
\usage{
pfw_zerofill(data)
}
\arguments{
\item{data}{A Project FeederWatch dataset, optionally filtered for species.}
}
\value{
A dataset with zerofilled values included for each species.
}
\description{
This function adds zeros for checklists where selected species were absent,
setting HOW_MANY = 0 for presence/absence-based analyses.
Note that zerofilling entire, unfiltered datasets from Project FeederWatch will take a long time!
}
\examples{
\dontrun{
# This example cannot be run because it relies on a cached version of the
# data which is created upon using pfw_import(). Storing a version of this
# for the example dataset would be too large for CRAN!

# Zerofill a PFW  dataset
data_zf <- pfw_zerofill(data)
}

}
