% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_model_info.R
\name{get_model_info}
\alias{get_model_info}
\alias{get_model_parameters}
\alias{get_model_covariates}
\alias{get_model_fixed_parameters}
\alias{get_model_structure}
\alias{get_model_linearity}
\alias{get_model_auc_compartment}
\alias{get_model_iov}
\title{Functions for getting information about a model}
\usage{
get_model_parameters(model)

get_model_covariates(model)

get_model_fixed_parameters(model)

get_model_structure(model)

get_model_linearity(model)

get_model_auc_compartment(model)

get_model_iov(model)
}
\arguments{
\item{model}{PKPDsim model}
}
\value{
get_model_parameters: returns a vector of PK parameter names

get_model_covariates: returns a vector of covariate names

get_model_fixed_parameters: returns a vector of names of parameters
that are not associated with inter-individual or inter-occasion
variability.

get_model_structure: returns a single string indicating model
structure. E.g.,: "1cmt_iv", "2cmt_oral".

get_model_linearity: returns a single string indicating model
linearity. E.g., "linear" or "nonlinear".

get_model_auc_compartment: returns the index of the final
compartment, which is conventionally the AUC compartment. Note: will not
detect if the final compartment is actually encoded to describe AUC.

get_model_iov: returns information about the IOV structure. For
models without IOV, returns a single field (\code{list(n_bins = 1)}). Models
with IOV will return additional fields: n_bins, bin durations, and CV
associated with each PK parameter.
}
\description{
PKPDsim models encode information about using the model that can be helpful
for working with the model. This family of functions provides an easier API
for accessing useful information. See also \code{attributes(model)} for less
commonly used model metadata. Functions will return \code{NULL} if the requested
field is not available.
}
