
test_that("Non positive definite matrix returns false", {
  expect_false(is_positive_definite(matrix(c(1, 2, 2, 4), nrow = 2)))
})

test_that("Positive definite matrix returns true", {
  expect_true(is_positive_definite(matrix(c(1, 2, 1, 4), nrow = 2)))
})

test_that("Positive definite matrix in triangle form returns true", {
  expect_true(is_positive_definite(c(1, 0, 2, 0, 0, 3.7)))
})

test_that("Matrix with complex eigen values returns FALSE", {
  expect_false(is_positive_definite(matrix(c(1, 2, -1, -4), nrow = 2)))
})

test_that("Matrix where numerical solver issues result in very tiny complex components", {
  x <- matrix(c(
    0.00552725632651592, 0.000302539251435238, 0.00703631214091069,
    0.00151961733931534, -0.00469749056857785, -3.62684481388847e-12,
    -3.6268459239869e-12, -3.62684611837635e-12, -0.000857391919568671,
    -6.63900366297602e-14, -6.63900449281235e-14, -6.63900380639596e-14,
    0.00094836773958462, 1.65028239969571e-09, 1.65028239966199e-09,
    1.65028239969571e-09, 0.00030253925143489, 0.0593445183221251,
    -0.0104842681515917, -0.00895056800075497, 0.000160987681950635,
    4.41449071663494e-11, 4.41449326638102e-11, 4.41449079736054e-11,
    -0.00642774403736556, 9.90409139108846e-12, 9.90409165495391e-12,
    9.90409143740584e-12, -0.00606086248833854, -8.46052335338979e-09,
    -8.46052335197563e-09, -8.46052335338987e-09, 0.00703631214091114,
    -0.010484268151589, 0.232378641986698, 0.0227131778945735, -0.00297143996841271,
    -4.03861305961836e-11, -4.03861854489647e-11, -4.03861849510585e-11,
    -0.0135357369445734, -3.05685537002417e-11, -3.05685540704862e-11,
    -3.0568553764992e-11, -0.0512878215063884, 1.82517120348625e-08,
    1.82517120348942e-08, 1.82517120348627e-08, 0.00151961733931543,
    -0.00895056800075467, 0.0227131778945738, 0.00350132738489801,
    -0.00109104079033964, -1.03028048646786e-11, -1.0302813271622e-11,
    -1.03028098949037e-11, -0.000467910178776184, -3.98327080969322e-12,
    -3.9832708790889e-12, -3.98327082184983e-12, -0.00342864930838694,
    3.06403254140599e-09, 3.06403254120985e-09, 3.06403254140602e-09,
    -0.00469749056857785, 0.000160987681950306, -0.00297143996841235,
    -0.00109104079033956, 0.00492577926180419, 6.28064455612011e-12,
    6.28064535355225e-12, 6.2806454258337e-12, 0.000594283052090545,
    1.36861323217699e-13, 1.36861327892652e-13, 1.36861324037281e-13,
    0.00131820139158967, -5.10690810552847e-10, -5.10690810566065e-10,
    -5.10690810552849e-10, -3.62684574893642e-12, 4.41448879064554e-11,
    -4.03861531372852e-11, -1.03028043454957e-11, 6.28064492764921e-12,
    0.00638449916493093, -4.35874733098177e-10, -4.35874731708463e-10,
    -1.24523990548988e-12, 1.35281059037749e-11, 1.35281086672644e-11,
    1.35281096415791e-11, -4.57689807341711e-11, 6.41901398342129e-08,
    6.41901398332037e-08, 6.41901398789359e-08, -3.6268459585449e-12,
    4.41449268563955e-11, -4.03861860393352e-11, -1.03028125360536e-11,
    6.2806454012705e-12, -4.35874735980451e-10, 0.00638449916493093,
    -4.35874734936509e-10, -1.24523959447622e-12, 1.35281079033086e-11,
    1.35281081355071e-11, 1.35281082172752e-11, -4.57689743017477e-11,
    6.41901398505033e-08, 6.41901398504213e-08, 6.41901398542762e-08,
    -3.62684654702797e-12, 4.41449131642621e-11, -4.03861814044189e-11,
    -1.03028103704327e-11, 6.28064528585543e-12, -4.35874735017053e-10,
    -4.35874733258411e-10, 0.00638449916493093, -1.24523599741643e-12,
    1.35281110364501e-11, 1.35281080406172e-11, 1.35281069845364e-11,
    -4.57689947775967e-11, 6.41901398638866e-08, 6.4190139864978e-08,
    6.41901398153906e-08, -0.000857391919568654, -0.00642774403736578,
    -0.0135357369445729, -0.000467910178776107, 0.000594283052090529,
    -1.24524074595977e-12, -1.24523561099241e-12, -1.24523563638168e-12,
    0.0220728380923865, 5.51592356034915e-12, 5.51592356509334e-12,
    5.51592356115003e-12, 0.00072598216780399, -5.71387618500361e-10,
    -5.71387618527929e-10, -5.71387618500357e-10, -6.63902505117159e-14,
    9.90409318403614e-12, -3.05685515962556e-11, -3.98327092049787e-12,
    1.36861160579572e-13, 1.35281071041577e-11, 1.35281091512026e-11,
    1.35281080276248e-11, 5.51592411267431e-12, 0.0250879982238107,
    1.83182801197341e-13, 1.83175096084484e-13, 4.28197109983845e-12,
    3.53932720279683e-10, 3.53932719377309e-10, 3.53932723072427e-10,
    -6.63902265129635e-14, 9.90409393935456e-12, -3.05685513678411e-11,
    -3.98327099957192e-12, 1.36861156365163e-13, 1.35281082226586e-11,
    1.35281092462509e-11, 1.35281068141807e-11, 5.51592403105426e-12,
    1.83193267775798e-13, 0.0250879982238107, 1.83183066346656e-13,
    4.28197102349075e-12, 3.53932723530385e-10, 3.53932709801601e-10,
    3.53932756520436e-10, -6.63902458572287e-14, 9.90409331734028e-12,
    -3.05685515380567e-11, -3.98327093283646e-12, 1.36861159550376e-13,
    1.35281063339271e-11, 1.35281090861201e-11, 1.35281088631796e-11,
    5.51592409731581e-12, 1.83171727690097e-13, 1.83186578607418e-13,
    0.0250879982238107, 4.28197107483497e-12, 3.53932734731925e-10,
    3.53932749080787e-10, 3.53932701641662e-10, 0.000948367739584575,
    -0.00606086248833911, -0.0512878215063879, -0.00342864930838683,
    0.00131820139158972, -4.57689988700203e-11, -4.57689849582349e-11,
    -4.57689680530206e-11, 0.000725982167804081, 4.28198189482636e-12,
    4.28198188686947e-12, 4.28198189400828e-12, 0.137320638001125,
    1.76996694468624e-08, 1.76996694439106e-08, 1.76996694468623e-08,
    1.65028239963385e-09, -8.46052335303631e-09, 1.82517120319052e-08,
    3.0640325410917e-09, -5.10690810506405e-10, 6.41901398258168e-08,
    6.41901398495263e-08, 6.41901398732623e-08, -5.71387618373401e-10,
    3.53932721962914e-10, 3.5393276164608e-10, 3.53932748081631e-10,
    1.76996694487392e-08, 0.166460407780184, 3.49649129455065e-06,
    3.49649129382181e-06, 1.65028239962275e-09, -8.46052335316377e-09,
    1.82517120317325e-08, 3.06403254109223e-09, -5.10690810504215e-10,
    6.41901398737781e-08, 6.4190139853575e-08, 6.41901398212526e-08,
    -5.71387618347318e-10, 3.53932721703902e-10, 3.53932731540833e-10,
    3.53932763414233e-10, 1.76996694486665e-08, 3.49649129406483e-06,
    0.166460407780184, 3.4964912945783e-06, 1.65028239963386e-09,
    -8.46052335303625e-09, 1.82517120319054e-08, 3.06403254109172e-09,
    -5.10690810506409e-10, 6.41901398349568e-08, 6.41901398502984e-08,
    6.41901398633503e-08, -5.7138761837346e-10, 3.53932760549283e-10,
    3.53932739733346e-10, 3.53932715063543e-10, 1.76996694487392e-08,
    3.49649129435825e-06, 3.4964912940532e-06, 0.166460407780184
  ),
  nrow = 16
  )
  is_x_positive_def <- is_positive_definite(x)
  expect_true(is_x_positive_def)
})

