% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chromatogram.R
\name{read_chrom}
\alias{read_chrom}
\title{Read Chromatogram Files}
\usage{
read_chrom(dir, format = "waters_raw", method)
}
\arguments{
\item{dir}{directory for chromatraograms}

\item{format}{format of the chromatogram files. Options are "waters_raw" and "mzML".}

\item{method}{LC-MS/MS method ID saved available in the database.}
}
\description{
This function reads chromatogram files from a directory and returns a data frame with the chromatogram data.
}
\examples{
\dontrun{
path <- system.file("extdata", "waters_raw_ex", package="PKbioanalysis")
main <- read_chrom(path, method = 1)
}
}
