% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{selectPLMIX_single}
\alias{selectPLMIX_single}
\title{Bayesian selection criteria for mixtures of Plackett-Luce models}
\usage{
selectPLMIX_single(
  pi_inv,
  G,
  MCMCsampleP = NULL,
  MCMCsampleW = NULL,
  MAPestP,
  MAPestW,
  deviance,
  post_est = "mean"
)
}
\arguments{
\item{pi_inv}{An object of class \code{top_ordering}, collecting the numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of partial orderings, or an object that can be coerced with \code{\link{as.top_ordering}}.}

\item{G}{Number of mixture components.}

\item{MCMCsampleP}{Numeric \eqn{L}\eqn{\times}{x}\eqn{G*K} matrix with the MCMC samples of the component-specific support parameters.}

\item{MCMCsampleW}{Numeric \eqn{L}\eqn{\times}{x}\eqn{G} matrix with the MCMC samples of the mixture weights.}

\item{MAPestP}{Numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix of MAP component-specific support parameter estimates.}

\item{MAPestW}{Numeric vector of the \eqn{G} MAP estimates of the mixture weights.}

\item{deviance}{Numeric vector of posterior deviance values.}

\item{post_est}{Character string indicating the  point estimates of the Plackett-Luce mixture parameters to be computed from the MCMC sample. This argument is ignored when MAP estimates are supplied in the \code{MAPestP} and \code{MAPestW} arguments. Default is \code{"mean"}. Alternatively, one can choose \code{"median"}.}
}
\value{
A list of named objects:

 \item{\code{point_estP}}{ Numeric \eqn{G}\eqn{\times}{x}\eqn{(K+1)} matrix with the point estimates of the Plackett-Luce mixture parameters. The \eqn{(K+1)}-th column contains estimates of the mixture weights.}
 \item{\code{point_estW}}{ Numeric \eqn{G}\eqn{\times}{x}\eqn{(K+1)} matrix with the point estimates of the Plackett-Luce mixture parameters. The \eqn{(K+1)}-th column contains estimates of the mixture weights.}
 \item{\code{D_bar}}{ Posterior expected deviance.}
 \item{\code{D_hat}}{ Deviance function evaluated at \code{point_est}.}
 \item{\code{pD}}{ Effective number of parameters computed as \code{D_bar}-\code{D_hat}.}
 \item{\code{pV}}{ Effective number of parameters computed as half the posterior variance of the deviance.}
 \item{\code{DIC1}}{ Deviance Information Criterion with penalty term equal to \code{pD}.}
 \item{\code{DIC2}}{ Deviance Information Criterion with penalty term equal to \code{pV}.}
 \item{\code{BPIC1}}{ Bayesian Predictive Information Criterion obtained from \code{DIC1} by doubling its penalty term.}
 \item{\code{BPIC2}}{ Bayesian Predictive Information Criterion obtained from \code{DIC2} by doubling its penalty term.}
 \item{\code{BICM1}}{ Bayesian Information Criterion-Monte Carlo.}
 \item{\code{BICM2}}{ Bayesian Information Criterion-Monte Carlo based on the actual MAP estimate given in the \code{MAPestP} and \code{MAPestW} arguments (unlike \code{BICM1}, no approximation of the MAP estimate from the MCMC sample).}
}
\description{
Compute Bayesian comparison criteria for mixtures of Plackett-Luce models with a different number of components.
}
\details{
Two versions of DIC and BPIC are returned corresponding to two alternative ways of computing the penalty term: the former was proposed by Spiegelhalter et al. (2002) and is denoted with \code{pD}, whereas the latter was proposed by Gelman et al. (2004) and is denoted with \code{pV}. DIC2 coincides with AICM, that is, the Bayesian counterpart of AIC introduced by Raftery et al. (2007).
}
\references{
Mollica, C. and Tardella, L. (2017). Bayesian Plackett-Luce mixture models for partially ranked data. \emph{Psychometrika}, \bold{82}(2), pages 442--458, ISSN: 0033-3123, <doi:10.1007/s11336-016-9530-0>.

Ando, T. (2007). Bayesian predictive information criterion for the evaluation of hierarchical Bayesian and empirical Bayes models. \emph{Biometrika}, \bold{94}(2), pages 443--458.

Raftery, A. E, Satagopan, J. M., Newton M. A. and Krivitsky, P. N. (2007). BAYESIAN STATISTICS 8. \emph{Proceedings of the eighth Valencia International Meeting 2006}, pages 371--416. Oxford University Press.

Gelman, A., Carlin, J. B., Stern, H. S. and Rubin, D. B. (2004). Bayesian data analysis. Chapman & Hall/CRC, Second Edition, ISBN: 1-58488-388-X. New York.

Spiegelhalter, D. J., Best, N. G., Carlin, B. P., Van Der Linde, A. (2002). Bayesian measures of model complexity and fit. \emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}, \bold{64}(4), pages 583--639.
}
\author{
Cristina Mollica and Luca Tardella
}
