% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{filter_rare_table_cols}
\alias{filter_rare_table_cols}
\title{Filters out columns of dataframe based on number of proportion of non-zero cells}
\usage{
filter_rare_table_cols(
  in_tab,
  min_nonzero_count,
  min_nonzero_prop,
  drop_missing_rows = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{in_tab}{input dataframe}

\item{min_nonzero_count}{minimum number of cells in column that must be non-zero for column to be retained.}

\item{min_nonzero_prop}{minimum proportion of cells in column that must be non-zero for column to be retained.}

\item{drop_missing_rows}{boolean flag to indicate whether rows with all zero values (after dropping columns based on specified cut-offs) should be removed.}

\item{verbose}{boolean flag to indicate that the number of columns removed should be written to the console.}
}
\value{
dataframe with columns that did not meet the \code{min_nonzero_count} and/or \code{min_nonzero_prop} options removed (and potentially rows dropped too if drop_missing_rows=TRUE).
}
\description{
Filters dataframe columns with either a low absolute count of non-zero values or a low proportion of rows with non-zero counts.
Note that this function is intended for positively-bounded data only (e.g., the function or taxon abundance tables), and will not work properly
if the table contains negative values. Included in package simply to make running workflow easier.
}
