% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_generator.R
\name{var_generator}
\alias{var_generator}
\title{PRISM regressors generator}
\usage{
var_generator(
  data,
  data.early,
  stl = TRUE,
  n.lag = 1:52,
  s.window = 52,
  n.history = 700
)
}
\arguments{
\item{data}{time series of interest as xts, last element can be NA.}

\item{data.early}{historical time series of response variable before Google Trend data is available. (e.g., unemployment initial claim prior to 2004)}

\item{stl}{if TRUE, use STL seasonal decomposition; if FALSE, use classic additive seasonal decomposition.}

\item{n.lag}{the number of lags to be used as regressor in Stage 2 of PRISM (by default = 1:52 for weekly data)}

\item{s.window}{seasonality span  (by default = 52 for weekly data)}

\item{n.history}{training period for seasonal decomposition. (by default = 700 wks)}
}
\value{
A list of following named objects
\itemize{
\item \code{y.lags} seasonally adjusted components, z_lag, and seasonal components, s_lag.
}
}
\description{
Stage 1 of PRISM. The function generates prism seasonal components and seasonally adjusted lag components.
}
