% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSIM.R
\name{psicalc}
\alias{psicalc}
\title{Preference Selection Index Method PSI}
\arguments{
\item{data}{A numeric data matrix, columns are the criteria, rows are the alternatives}

\item{optimization}{A character vector with definition of minimization or maximization for each criterion, expected 'min' or 'max' only}
}
\value{
dataframe with 3 columns: critério, phi_j and psi_j
}
\description{
Implementation of An PREFERENCE SELECTION INDEX METHOD - PSI
More information about the method at https://doi.org/10.1016/j.matdes.2009.11.020
More information about the implementation at https://github.com/luana1909/PSIM/blob/main/DESCRIPTION
The goal is to determine the weights of criteria
}
\examples{
optimizations <- c("min","min", "max", "max") #"min" and "max" should be all lowercase
decision_matrix <- data.frame(criterio1 = c(7000, 15000, 20000),
                              criterio2 = c(700, 800, 1000),
                              criterio3 = c(280, 300, 180),
                              criterio4 = c(120, 880, 1200))
result <- psicalc(decision_matrix, optimizations)
}
