% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BETMSI.R
\name{BETMSI}
\alias{BETMSI}
\title{Brunauer-Emmett-Teller(BET) Moisture Sorption Isotherm}
\usage{
BETMSI(WaterAct, AdsorpM, DesorpM)
}
\arguments{
\item{WaterAct}{the numerical value of Water Activity, which ranges from 0 to 1.}

\item{AdsorpM}{the numerical value of the Moisture content of the Adsorption curve, which ranges from 0 to 1.}

\item{DesorpM}{the numerical value of the Moisture content of the Desorption curve, which ranges from 0 to 1.}
}
\value{
the nonlinear regression, parameters, and graphical visualization for the Brunauer-Emmett-Teller(BET) Moisture Sorption Isotherm model.
}
\description{
Brunauer-Emmett-Teller(BET) is a two-parameter isotherm model used for the optimum moisture content determination for drying and storage stability of foods, and in the food's surface area estimation.
}
\examples{
\donttest{WaterAct <- c(0.1145,0.2274,0.3265,0.4291,0.6342,0.7385,0.8274,0.9573)
AdsorpM <- c(0.0234, 0.0366, 0.0496, 0.0648, 0.0887, 0.1096, 0.1343, 0.1938)
DesorpM <- c(0.0459, 0.0637, 0.0794, 0.0884, 0.1158, 0.1298,0.1500, 0.1938)
BETMSI(WaterAct, AdsorpM, DesorpM)}
}
\references{
Aviara, N. A., et al. (2016). Effect of Temperature and Moisture Sorption Hysteresis on Monolayer Moisture Content of Selected Crops Determined Using BET and GAB Models. 37Th Annual Conference and Annual General Meeting-"Minna 2016," October.

Staudt, P. B., et al. (2013) <doi:10.1016/j.jfoodeng.2012.07.016> A new method for predicting sorption isotherms at different temperatures using the BET model. Journal of Food Engineering, 114(1), 139-145.
}
\author{
Benz L. Rivera

John Carlo F. Panganiban

Kim M. Villacorte

Chester C. Deocaris
}
