#' @title Total number of structure by types and rural/urban
#' @name   TABLE_26
#' @docType data
#' @keywords datasets
#' @usage data(TABLE_26)
#' @description \code{TABLE_26} Total number of structure by types and rural/urban
#' @format A \code{data.table} and  \code{data.frame}.
#' \describe{
#'   \item{\code{PROVINCE}}{PROVINCE}
#'   \item{\code{DIVISION}}{DIVISION}
#'   \item{\code{DISTRICT}}{DISTRICT}
#'   \item{\code{TEHSIL}}{TEHSIL}
#'   \item{\code{ADMIN_UNIT}}{ADMIN UNIT}
#'   \item{\code{REGION}}{REGION}
#'   \item{\code{ALL_STRUCTURES}}{ALL STRUCTURES}
#'   \item{\code{HIGH_RISE_RES}}{HIGH RISE RESIDENTIAL}
#'   \item{\code{HIGH_RISE_ECON}}{HIGH RISE ECONOMIC}
#'   \item{\code{HIGH_RISE_RES_ECON}}{HIGH RISE RESIDENTIAL & ECONOMIC}
#'   \item{\code{NORMAL_RES}}{NORMAL RESIDENTIAL}
#'   \item{\code{NORMAL_ECON}}{NORMAL ECONOMIC}
#'   \item{\code{NORMAL_RES_ECON}}{NORMAL RESIDENTIAL & ECONOMIC}
#'   \item{\code{OTHER_JUGHI}}{OTHER JUGHI}
#'   \item{\code{OTHER_UNDER_CONSTR}}{OTHER UNDER CONSTRUCTION}
#'        }
#'
#' @author Muhammad Yaseen (\email{myaseen208@@gmail.com})
#'
#' @references \enumerate{
#' \item Pakistan Population Census 2023 (\url{https://www.pbs.gov.pk/}).
#'  }
#' 
#' @seealso
#'    \code{\link{PakPC2023PakDiv}}
#'  , \code{\link{PakPC2023PakDist}}
#'
#' @import DT htmltools
#' 
#' @examples
#' data(TABLE_26)
NULL
