% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PortfolioRisk.R
\name{portfolio-moments}
\alias{portfolio-moments}
\alias{portm2}
\alias{derportm2}
\alias{portm3}
\alias{derportm3}
\alias{portm4}
\alias{derportm4}
\title{Portfolio moments}
\usage{
portm2(w, sigma)

derportm2(w, sigma)

portm3(w, M3)

derportm3(w, M3)

portm4(w, M4)

derportm4(w, M4)
}
\arguments{
\item{w}{vector of length p with portfolio weights}

\item{sigma}{portfolio covariance matrix of dimension p x p}

\item{M3}{matrix of dimension p x p^2, or a vector with 
(p * (p + 1) * (p + 2) / 6) unique coskewness elements}

\item{M4}{matrix of dimension p x p^3, or a vector with 
(p * (p + 1) * (p + 2) * (p + 3) / 12) unique coskewness elements}
}
\description{
computes the portfolio second, third and fourth central moments given the 
multivariate comoments and the portfolio weights. The gradient functions
compute the gradient of the portfolio central moment with respect to the
portfolio weights, evaluated in the portfolio weights.
}
\details{
For documentation on the coskewness and cokurtosis matrices, we refer to
?CoMoments. Both the full matrices and reduced form can be the used as
input for the function related to the portfolio third and fourth central
moments.
}
\examples{

data(managers)

# equal weighted portfolio of managers
p <- ncol(edhec)
w <- rep(1 / p, p)

# portfolio variance and its gradient with respect to the portfolio weights
sigma <- cov(edhec)
pm2 <- portm2(w, sigma)
dpm2 <- derportm2(w, sigma)

# portfolio third central moment and its gradient with respect to the portfolio weights
m3 <- M3.MM(edhec)
pm3 <- portm3(w, m3)
dpm3 <- derportm3(w, m3)

# portfolio fourth central moment and its gradient with respect to the portfolio weights
m4 <- M4.MM(edhec)
pm4 <- portm4(w, m4)
dpm4 <- derportm4(w, m4)

}
\seealso{
\code{\link{CoMoments}} \cr \code{\link{ShrinkageMoments}} \cr \code{\link{EWMAMoments}}
\cr \code{\link{StructuredMoments}} \cr \code{\link{MCA}}
}
\author{
Kris Boudt, Peter Carl, Dries Cornilly, Brian Peterson
}
\concept{co-moments}
\concept{moments}
