% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultivariateMoments.R
\name{unique-comoments}
\alias{unique-comoments}
\alias{M3.vec2mat}
\alias{M3.mat2vec}
\alias{M4.vec2mat}
\alias{M4.mat2vec}
\title{Helper function for comoment matrices}
\usage{
M3.vec2mat(M3, p)

M3.mat2vec(M3)

M4.vec2mat(M4, p)

M4.mat2vec(M4)
}
\arguments{
\item{M3}{matrix of dimension p x p^2, or a vector with 
(p * (p + 1) * (p + 2) / 6) unique coskewness elements}

\item{p}{number of variables; the number of instruments for which the
coskewness or cokurtosis matrix/vector was computed}

\item{M4}{matrix of dimension p x p^3, or a vector with 
(p * (p + 1) * (p + 2) * (p + 3) / 12) unique coskewness elements}
}
\description{
transforms vector with unique coskewness or cokurtosis elements to the full
coskewness and cokurtosis matrix. Also works in the reverse direction by 
extracting the unique coskewness and cokurtosis elements from full the 
coskewness or cokurtosis matrices.
}
\details{
For documentation on the coskewness and cokurtosis matrices, we refer to
?CoMoments. Both the full matrices and reduced form can be the output of
M3.MM and M4.MM, depending on the optional argument as.mat.
}
\examples{

data(managers)
p <- ncol(edhec)

# transform coskewness between matrix and vector format
m3 <- M3.MM(edhec, as.mat=TRUE)
m3bis <- M3.vec2mat(M3.MM(edhec, as.mat=FALSE), p)
sum((m3 - m3bis)^2)

# transform cokurtosis between matrix and vector format
m4 <- M4.MM(edhec, as.mat=FALSE)
m4bis <- M4.mat2vec(M4.MM(edhec, as.mat=TRUE))
sum((m4 - m4bis)^2)

}
\seealso{
\code{\link{CoMoments}} \cr \code{\link{ShrinkageMoments}} \cr \code{\link{EWMAMoments}}
\cr \code{\link{StructuredMoments}} \cr \code{\link{MCA}} \cr \code{\link{NCE}}
}
\author{
Kris Boudt, Peter Carl, Dries Cornilly, Brian Peterson
}
\concept{co-moments}
\concept{moments}
