% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asym_test.R
\name{asym_test}
\alias{asym_test}
\title{Large Sample Approximation (Asymptotic) Test of Correlation Coefficients}
\usage{
asym_test(
  x,
  y,
  r0 = 0,
  w = NULL,
  method = c("Pearson", "wtdPearson", "Spearman", "CCC"),
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{x}{a \code{numeric} vector.}

\item{y}{a \code{numeric} vector.}

\item{r0}{a \code{numeric} denoting the CCC under the null hypothesis. It should be in the range between
-1 and 1. This parameter will be ignored for the tests of Pearson, weighted Pearson, or Spearman's
correlation coefficient.}

\item{w}{\code{numeric} vector denoting the weights of the elements in vectors \code{x} and \code{y}.}

\item{method}{the correlation coefficient to be tested, options include Pearson's correlation coefficient
(\code{Pearson}), weighted Pearson correlation coefficient (\code{wtdPearson}),
Spearman's correlation coefficient (\code{Spearman}), Lin's concordance correlation coefficient (\code{CCC}).}

\item{alternative}{the alternative hypothesis, can be \code{two.sided}, \code{less}, or \code{greater}.}
}
\value{
\describe{
\item{\code{estimate}}{the estimated correlation coefficient.}
\item{\code{p.value}}{the p-value from the studentized test.}
\item{\code{method}}{the method for measuring correlation coefficient.}
\item{\code{alternative}}{the alternative hypothesis.}
}
}
\description{
This function performs a large sample approximation test of correlation coefficients, ensuring control over
type I error under general scenarios when the sample size exceeds 200. It is suitable for cases where two
variables are dependent but uncorrelated.
}
\details{
#' The test supports the following correlation coefficients: Pearson correlation coefficient, Weighted
Pearson correlation coefficient, Spearman correlation coefficient, and Lin's concordance correlation coefficient (CCC)

For Pearson, weighted Pearson, and Spearman correlation coefficients, the test supports a zero null
hypothesis. The alternative hypothesis can be either one-sided or two-sided.

For Lin's concordance correlation coefficient (CCC), the test accommodates a more general null hypothesis.
Currently, the test only supports a one-sided alternative hypothesis (greater).
}
\examples{
set.seed(123)
x <- rnorm(250)
y <- rnorm(250)
asym_test(x, y, method = "Pearson", alternative = "greater")

asym_test(x, y, method = "Spearman", alternative = "two.sided")

asym_test(x, y, w = rep(0.004,250), method = "wtdPearson", alternative = "less")

asym_test(x, y, r0 = -0.5, method = "CCC", alternative = "greater")
}
\references{
Lawrence, I., & Lin, K. (1989). A concordance correlation coefficient to evaluate reproducibility. Biometrics, 255-268.

Serfling, R. J. (2009). Approximation theorems of mathematical statistics. John Wiley & Sons.
}
\author{
Mengyu Fang, Han Yu, Alan Hutson
}
