% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_peru_life_expectancy.R
\name{get_peru_life_expectancy}
\alias{get_peru_life_expectancy}
\title{Get Peru's Life Expectancy at Birth (Total, Years) from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SP.DYN.LE00.IN}
}
\usage{
get_peru_life_expectancy()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Life expectancy at birth, total (years)")
  \item \code{country}: Country name ("Peru")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Life expectancy at birth in years
}
}
\description{
Retrieves Peru's life expectancy at birth (total, years)
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{SP.DYN.LE00.IN}.
}
\details{
This function sends a GET request to the World Bank API.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_peru_life_expectancy()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
