% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOL.R
\name{TOL}
\alias{TOL}
\title{Stress Tolerance (TOL)}
\usage{
TOL(Gen, YN, YS)
}
\arguments{
\item{Gen}{Character vector of Genotype identifiers.}

\item{YN}{Numeric vector: yield (any trait) under non-stress (normal) environment.}

\item{YS}{Numeric vector: yield (any trait) under stress environment.}
}
\value{
A list of output columns:
\itemize{
\item \code{Gen}: Character vector of genotype IDs.
\item \code{TOL}: Estimated stress tolerance (TOL) values for respective genotypes.
}
\deqn{TOL = YN - YS}
}
\description{
This function computes stress tolerance (TOL) using any traits like yield under stress and non-stress conditions. The lower values of TOL indicates greater tolerance. For more details see Rosielle and Hamblin (1981) \url{doi:10.2135/cropsci1981.0011183X002100060033x}.
}
\examples{
TOL(Gen=c("G1","G2","G3"), YN=c(10,8,5), YS=c(7,5,3))

}
\references{
Rosielle, A.A. and Hamblin, J. (1981). \url{doi:10.2135/cropsci1981.0011183X002100060033x}.
}
