% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alternatives.R
\name{findA}
\alias{findA}
\title{Estimate parameter for a given beta KL divergence and UMP
test}
\usage{
findA(w, logd = 0, ...)
}
\arguments{
\item{w}{UMP parameter between 0 and 1}

\item{logd}{numeric value, the log KL divergence}

\item{...}{additional arguments to uniroot}
}
\value{
A real value.
}
\description{
Computes the first parameter value for a given KL
divergence and UMP test.
}
\details{
This function uses uniroot to invert the beta divergence
for a given w and return the a value which gives that beta
divergence given the UMP parameter w. The search interval is
specified internally, so should not be passed in using additional
argument.
}
\examples{
findA(0.5, logd = 0)
}
\author{
Chris Salahub
}
