% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plausibleAlts.R
\name{marHistHeatMap}
\alias{marHistHeatMap}
\title{Heatmap with marginal histograms}
\usage{
marHistHeatMap(
  mat,
  main = "",
  ylab = expression(eta),
  xlab = "lnD(a,w)",
  pal = NULL,
  histFill = adjustcolor("firebrick", 0.5),
  ...
)
}
\arguments{
\item{mat}{numeric matrix to be plotted}

\item{main}{title}

\item{ylab}{y axis label}

\item{xlab}{x axis label}

\item{pal}{palette for heatmap}

\item{histFill}{colour to fill histogram bars}

\item{...}{additional arguments to image}
}
\value{
Plot the data using a heatmap and marginal histograms and
return nothing.
}
\description{
Display a matrix using a heatmap with marginal
histograms.
}
\details{
This function accepts a matrix of values and plots the
matrix with saturation/hue determined by a provided palette
argument generated by colorRampPalette, for example. Marginal
histograms summarizing the relative frequencies along both
dimensions are also plotted to give a complete sense of the
individual distributions alongside their joint distribution.
This was designed to summarize the alternative distribution
space summarized by altFrequencyMat, and the defaults reflect
this.
}
\examples{
marHistHeatMap(altFrequencyMat(c(0, 2)))
}
\author{
Chris Salahub
}
