% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_function.R
\name{pdr_cost}
\alias{pdr_cost}
\title{Cost function between observed and predicted pools}
\usage{
pdr_cost(
  params,
  time,
  m,
  n,
  m_prec,
  ap_prec,
  P,
  k,
  pool = "CH4",
  frac_P = frac_P_default(pool),
  frac_k = frac_k_default(pool),
  log_progress = NULL
)
}
\arguments{
\item{params}{Named list holding optimizer-assigned values for parameters}

\item{time}{Vector of numeric time values; first should be zero}

\item{m}{Observed total pool size, same length as time}

\item{n}{Observed pool size of heavy isotope, same length as time}

\item{m_prec}{Instrument precision for pool size, expressed as a standard deviation}

\item{ap_prec}{Instrument precision for atom percent, expressed as a standard deviation}

\item{P}{production rate, unit pool size/unit time}

\item{k}{first-order rate constant for consumption, 1/unit time}

\item{pool}{Name of pool; see \code{\link{pdr_fractionation}}}

\item{frac_P}{Fractionation value for production; see \code{\link{pdr_fractionation}}}

\item{frac_k}{Fractionation value for consumption; see \code{\link{pdr_fractionation}}}

\item{log_progress}{An optional logging function}
}
\value{
Returns a cost metric summarizing the difference between the
predicted and observed \code{m} (total pool size) and \code{AP} (atom percent).
}
\description{
Cost function between observed and predicted pools
}
\note{
This implements Equations 12-14 from von Fischer and Hedin (2002).
}
\examples{
m <- c(10, 8, 6, 5, 4, 3)
n <- c(1, 0.7, 0.6, 0.4, 0.3, 0.2)
pdr_cost(params = list(P = 0.5, k = 0.3), time = 0:5, m, n, m_prec = 0.001, ap_prec = 0.01)
}
\author{
K.A. Morris & B. Bond-Lamberty
}
