% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.R
\name{pdr_optimize}
\alias{pdr_optimize}
\title{Optimize production and consumption parameters for pool dilution data}
\usage{
pdr_optimize(
  time,
  m,
  n,
  m_prec,
  ap_prec,
  P,
  k,
  params_to_optimize = c("P", "k"),
  pool = "CH4",
  frac_P = NULL,
  frac_k = NULL,
  other_params = list(),
  cost_fn = pdr_cost,
  prediction_fn = pdr_predict,
  include_progress = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{time}{Vector of numeric time values (e.g. days); first should be zero}

\item{m}{Observed total pool size (as a volume), same length as time}

\item{n}{Observed heavy isotope (as a volume), same length as time}

\item{m_prec}{Instrument precision for pool size, expressed as a standard deviation}

\item{ap_prec}{Instrument precision for atom percent, expressed as a standard deviation}

\item{P}{production rate, unit gas/unit time}

\item{k}{first-order rate constant for consumption, 1/unit time}

\item{params_to_optimize}{Named vector of parameters ("P", "k", "frac_P",
and/or "frac_k") to optimize against observations}

\item{pool}{Name of pool to use when looking up fractionation values if they
are not supplied; see \code{\link{pdr_fractionation}}}

\item{frac_P}{Fractionation value for production; see \code{\link{pdr_fractionation}}}

\item{frac_k}{Fractionation value for consumption; see \code{\link{pdr_fractionation}}}

\item{other_params}{Other parameters pass on to \code{\link{optim}}}

\item{cost_fn}{Cost function to use; the default is \code{\link{pdr_cost}}}

\item{prediction_fn}{Prediction function that the cost function will use;
the default is \code{\link{pdr_predict}}}

\item{include_progress}{Include detailed optimizer progress data in output?}

\item{quiet}{Suppress output messages, logical}
}
\value{
The output of \code{\link{optim}}.
}
\description{
Optimize production and consumption parameters for pool dilution data
}
\note{
Currently there is only one set of fractionation values available in
\code{\link{pdr_fractionation}}, from von Fischer and Hedin
(2002, 10.1029/2001GB001448).
}
\examples{
tm <- 0:5
m <- c(10, 8, 6, 5, 4, 3)
n <- c(1, 0.7, 0.6, 0.4, 0.3, 0.2)
m_prec <- 0.001
ap_prec <- 0.01

# Optimize values for P (production) and k (consumption), provide starting values for P and k
pdr_optimize(time = tm, m, n, m_prec, ap_prec, P = 0.5, k = 0.3)
# If we don't provide a value for k, it can be estimated from the data
pdr_optimize(tm, m, n, m_prec, ap_prec, P = 0.5)
# Hold k and frac_k constant (ie., k = estimated k0, frac_k = default value), optimize P and frac_P
pdr_optimize(tm, m, n, m_prec, ap_prec, P = 0.5, params_to_optimize = c("P", "frac_P"))
# Optimize only k (provide P and exclude from params_to_optimize)
pdr_optimize(tm, m, n, m_prec, ap_prec, P = 0.5, params_to_optimize = "k")
# Optimize only k, bounding its possible values
op <- list(lower = c("k" = 0.2), upper = c("k" = 0.3))
pdr_optimize(tm, m, n, m_prec, ap_prec, 0.5, 0.27, params_to_optimize = "k", other_params = op)
}
\seealso{
\code{\link{pdr_optimize_df}}
}
