% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_vis_sample.R
\name{pca_sample}
\alias{pca_sample}
\title{Generate PCA of Ligand-Receptor Interaction Scores}
\usage{
pca_sample(
  lr_scores,
  metadata,
  selected_sender = NULL,
  selected_receiver = NULL,
  color_by = NULL,
  n_components = 2
)
}
\arguments{
\item{lr_scores}{Data frame containing LR interaction scores per sample (data frame).}

\item{metadata}{Data frame containing sample metadata (data frame).}

\item{selected_sender}{Specific sender cell type to filter, default is None (use all) (character).}

\item{selected_receiver}{Specific receiver cell type to filter, default is None (use all) (character).}

\item{color_by}{\code{metadata} column name to color points in PCA plot (character).}

\item{n_components}{Number of principal components to extract (numeric, default: 2).}
}
\value{
A list containing:
\itemize{
\item plot - ggplot object of the PCA scatter plot
\item df - data frame used for the PCA results
}
}
\description{
This function performs principal component analysis (PCA) on ligand-receptor (LR) interaction scores across samples,
and generates a scatter plot of the first two principal components. Optionally, sample metadata can be used to color the points.
}
\examples{
# PCA of LR Interaction Scores
data(lr_scores_eg)
data(metadata_eg)

res <- pca_sample(
  lr_scores = lr_scores_eg,
  metadata = metadata_eg,
  color_by = "IFN_type"
  )

print(res$plot)
head(res$df)
}
