% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ofv_and_fim.R
\name{calc_ofv_and_fim}
\alias{calc_ofv_and_fim}
\title{Calculate the Fisher Information Matrix (FIM) and the OFV(FIM) for either point values or parameters or distributions.}
\usage{
calc_ofv_and_fim(
  poped.db,
  ofv = 0,
  fim = 0,
  d_switch = poped.db$settings$d_switch,
  bpopdescr = poped.db$parameters$bpop,
  ddescr = poped.db$parameters$d,
  bpop = bpopdescr[, 2, drop = F],
  d = getfulld(ddescr[, 2, drop = F], poped.db$parameters$covd),
  docc_full = getfulld(poped.db$parameters$docc[, 2, drop = F],
    poped.db$parameters$covdocc),
  model_switch = poped.db$design$model_switch,
  ni = poped.db$design$ni,
  xt = poped.db$design$xt,
  x = poped.db$design$x,
  a = poped.db$design$a,
  fim.calc.type = poped.db$settings$iFIMCalculationType,
  use_laplace = poped.db$settings$iEDCalculationType,
  laplace.fim = FALSE,
  ofv_fun = poped.db$settings$ofv_fun,
  evaluate_fim = TRUE,
  ...
)
}
\arguments{
\item{poped.db}{A PopED database.}

\item{ofv}{The current ofv.  If other than zero then this value is simply returned unchanged.}

\item{fim}{The current FIM. If other than zero then this value is simply returned unchanged.}

\item{d_switch}{\itemize{
\item \bold{******START OF CRITERION SPECIFICATION OPTIONS**********}}
D-family design (1) or ED-family design (0) (with or without parameter uncertainty)}

\item{bpopdescr}{Matrix defining the fixed effects, per row (row number =
parameter_number) we should have: \itemize{ \item column 1 the type of the
distribution for E-family designs (0 = Fixed, 1 = Normal, 2 = Uniform, 3 =
User Defined Distribution, 4 = lognormal and 5 = truncated normal) \item
column 2  defines the mean. \item column 3 defines the variance of the
distribution (or length of uniform distribution). }}

\item{ddescr}{Matrix defining the diagonals of the IIV (same logic as for
the \code{bpopdescr}).}

\item{bpop}{Matrix defining the fixed effects, per row (row number = parameter_number) we should have:
\itemize{
\item column 1 the type of the distribution for E-family designs (0 = Fixed, 1 = Normal, 2 = Uniform,
 3 = User Defined Distribution, 4 = lognormal and 5 = truncated normal)
\item column 2  defines the mean.
\item column 3 defines the variance of the distribution (or length of uniform distribution).
}
Can also just supply the parameter values as a vector \code{c()} if no uncertainty around the 
parameter value is to be used. The parameter order of  'bpop' is defined in the 'fg_fun' or 'fg_file'. If you use named 
arguments in 'bpop' then the order of this vector can be rearranged to match the 'fg_fun' or 'fg_file'. 
See `reorder_parameter_vectors`.}

\item{d}{Matrix defining the diagonals of the IIV (same logic as for the fixed effects 
matrix bpop to define uncertainty). One can also just supply the parameter values as a \code{c()}. 
The parameter order of 'd' is defined in the 'fg_fun' or 'fg_file'. If you use named 
arguments in 'd' then the order of this vector can be rearranged to match the 'fg_fun' or 'fg_file'. 
See `reorder_parameter_vectors`.}

\item{docc_full}{A between occasion variability matrix.}

\item{model_switch}{A matrix that is the same size as xt, specifying which model each sample belongs to.}

\item{ni}{A vector of the number of samples in each group.}

\item{xt}{A matrix of sample times.  Each row is a vector of sample times for a group.}

\item{x}{A matrix for the discrete design variables.  Each row is a group.}

\item{a}{A matrix of covariates.  Each row is a group.}

\item{fim.calc.type}{The method used for calculating the FIM. Potential values:
\itemize{
\item 0 = Full FIM.  No assumption that fixed and random effects are uncorrelated.  
\item 1 = Reduced FIM. Assume that there is no correlation in the FIM between the fixed and random effects, and set these elements in 
the FIM to zero. 
\item 2 = weighted models (placeholder).
\item 3 = Not currently used.
\item 4 = Reduced FIM and computing all derivatives with respect to the standard deviation of the residual unexplained variation (sqrt(SIGMA) in NONMEM). 
This matches what is done in PFIM, and assumes that the standard deviation of the residual unexplained variation is the estimated parameter
(NOTE: NONMEM estimates the variance of the residual unexplained variation by default). 
\item 5 = Full FIM parameterized with A,B,C matrices & derivative of variance. 
\item 6 = Calculate one model switch at a time, good for large matrices. 
\item 7 = Reduced FIM parameterized with A,B,C matrices & derivative of variance.
}}

\item{use_laplace}{Should the Laplace method be used in calculating the expectation of the OFV?}

\item{laplace.fim}{Should an E(FIM) be calculated when computing the Laplace approximated E(OFV).  Typically
the FIM does not need to be computed and, if desired,  this calculation
is done using the standard MC integration technique, so can be slow.}

\item{ofv_fun}{User defined function used to compute the objective function. The function must have a poped database object as its first
argument and have "..." in its argument list.  Can be referenced as a function or as a file name where the function defined in the file has the same name as the file.
e.g. "cost.txt" has a function named "cost" in it.}

\item{evaluate_fim}{Should the FIM be calculated?}

\item{...}{Other arguments passed to the function.}
}
\value{
A list containing the FIM and OFV(FIM) or the E(FIM) and E(OFV(FIM)) according  to the function arguments.
}
\description{
This function computes the expectation of the FIM and OFV(FIM) for either point values of parameter estimates
or parameter distributions given the model, parameters, 
distributions of parameter uncertainty, design and methods defined in the 
PopED database.
}
\examples{
library(PopED)

############# START #################
## Create PopED database
## (warfarin model for optimization
##  with parameter uncertainty)
#####################################

## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## Optimization using an additive + proportional reidual error
## to avoid sample times at very low concentrations (time 0 or very late samoples).

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

# Adding 10\% log-normal Uncertainty to fixed effects (not Favail)
bpop_vals <- c(CL=0.15, V=8, KA=1.0, Favail=1)
bpop_vals_ed_ln <- cbind(ones(length(bpop_vals),1)*4, # log-normal distribution
                         bpop_vals,
                         ones(length(bpop_vals),1)*(bpop_vals*0.1)^2) # 10\% of bpop value
bpop_vals_ed_ln["Favail",]  <- c(0,1,0)
bpop_vals_ed_ln

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_fun=ff.PK.1.comp.oral.sd.CL,
                                  fg_fun=sfg,
                                  fError_fun=feps.add.prop,
                                  bpop=bpop_vals_ed_ln, 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=c(0.01,0.25),
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0,
                                  maxxt=120,
                                  a=70,
                                  mina=0,
                                  maxa=100)

############# END ###################
## Create PopED database
## (warfarin model for optimization
##  with parameter uncertainty)
#####################################


calc_ofv_and_fim(poped.db)

\dontrun{
  
  calc_ofv_and_fim(poped.db,d_switch=0)
  calc_ofv_and_fim(poped.db,d_switch=0,use_laplace=TRUE)
  calc_ofv_and_fim(poped.db,d_switch=0,use_laplace=TRUE,laplace.fim=TRUE)

}
}
\seealso{
Other FIM: 
\code{\link{LinMatrixH}()},
\code{\link{LinMatrixLH}()},
\code{\link{LinMatrixL_occ}()},
\code{\link{ed_laplace_ofv}()},
\code{\link{ed_mftot}()},
\code{\link{efficiency}()},
\code{\link{evaluate.e.ofv.fim}()},
\code{\link{evaluate.fim}()},
\code{\link{gradf_eps}()},
\code{\link{mf3}()},
\code{\link{mf7}()},
\code{\link{mftot}()},
\code{\link{ofv_criterion}()},
\code{\link{ofv_fim}()}

Other E-family: 
\code{\link{ed_laplace_ofv}()},
\code{\link{ed_mftot}()},
\code{\link{evaluate.e.ofv.fim}()}

Other evaluate_FIM: 
\code{\link{evaluate.e.ofv.fim}()},
\code{\link{evaluate.fim}()},
\code{\link{ofv_fim}()}
}
\concept{E-family}
\concept{FIM}
\concept{evaluate_FIM}
