% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_test.R
\name{pred_test}
\alias{pred_test}
\title{Predictive Test Function}
\usage{
pred_test(
  weights_vector,
  results_vector,
  test_type = "exact",
  phi_0 = 0.5,
  sims = 5000
)
}
\arguments{
\item{weights_vector}{A numeric vector where each element represents the weight for a corresponding result in the results vector. Each value must be on the interval \eqn{[1/m, 1]}, where \eqn{m = 1/length(weights_vector)}.}

\item{results_vector}{A numeric vector of test results where each element is in the set \{0, 1\}, representing the binary outcome of each prediction.}

\item{test_type}{A character string specifying the type of statistical test to perform. The valid options are 'exact', 'approx', or 'bootstrap'.}

\item{phi_0}{A numeric value on the interval (0, 1) representing the null hypothesis value against which the test results are compared.}

\item{sims}{A natural number that specifies the number of simulations to perform when the bootstrap method is chosen. This parameter allows control over the robustness of the bootstrap approximation.}
}
\value{
A list containing:
\describe{
\item{num_correctly_predicted}{The number of results correctly predicted as per the specified criteria.}
\item{p_value}{The p-value resulting from the test, indicating the probability of observing the test results under the null hypothesis.}
\item{test_stat}{The test statistic calculated based on the weights and results.}
\item{p0}{The estimated proportion derived from the weights and results.}
\item{ci}{A confidence interval for the estimated proportion derived from the weights and results using the Wilson score method.}
}
}
\description{
This function performs statistical tests to determine the predictive power of a results set weighted by a corresponding vector of weights. It offers various methods to conduct the test, allowing flexibility depending on the data characteristics and analysis requirements.
}
\details{
This function performs error handling to ensure appropriate input values and types. It then calculates the test statistic and evaluates the p-value based on the specified test type.
}
\examples{
# Example weights and results vectors
weights_vector <- c(1/3, 0.5, 1)
results_vector <- c(0, 1, 1)

# Exact test
result_exact <- pred_test(weights_vector, results_vector, test_type = 'exact')
result_exact

# Approximate test
result_approx <- pred_test(weights_vector, results_vector, test_type = 'approx')
result_approx

# Bootstrap test
result_bootstrap <- pred_test(weights_vector, results_vector, test_type = 'bootstrap')
result_bootstrap

}
