% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GP_maintest.R
\name{DMBAR_Test}
\alias{DMBAR_Test}
\title{Constructs the DMBAR Test statistic in GP2023}
\usage{
DMBAR_Test(ehat0, ehatj, mu0, pvcutoffkp)
}
\arguments{
\item{ehat0}{n by 1 vector of out of sample forecast errors from benchmark model with only intercept.}

\item{ehatj}{n by j vector of out of sample forecast errors from models (j=1,...,p) estimated with one predictor (j) per time.}

\item{mu0}{sample split parameter (must be different from 0.5).}

\item{pvcutoffkp}{pvalue cutoff used to decide whether the global null is rejected when identifying the key player conditional on rejecting the global null.}
}
\value{
A list of Test statistic, pvalue and key player across 4 alternative formulations of the test statistics (lrvar under 0 vs 1; power enhanced vs non-power enhanced (notation: 0, 1, 0adj, 1adj).
}
\description{
Consider a linear predictive regression setting with a potentially large set of candidate predictors.
This work is concerned with detecting the presence of out of sample predictability based on out of sample MSE comparisons.
For details of the test, please refer to Gonzalo and Pitarakis (2023).
}
\examples{
ehat0<- rnorm(15);
ehatj<- rnorm(15);
temp <- DMBAR_Test(ehat0,ehatj,mu0=0.4,pvcutoffkp=0.1);
}
\references{
Gonzalo, J., & Pitarakis, J. Y. (2023). Out-of-sample predictability in predictive regressions with many predictor candidates. International Journal of Forecasting, 1166-1178.
}
