% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PROMETHEEII.R
\name{PROMETHEEII}
\alias{PROMETHEEII}
\title{The PROMETHEE Outranking Method}
\usage{
PROMETHEEII(matrix_evaluation, data_criteria)
}
\arguments{
\item{matrix_evaluation}{The matrix includes the values for all alternatives.
The alternatives profiles are rows and columns correspond to the evaluation
criteria.}

\item{data_criteria}{Matrix with the parameter information (rows) for each
criterion (columns). The rows of parameters are in the following order:
Function Type, Indifference Threshold, Preference Threshold, Objective and
Weight.}
}
\value{
-\code{NF} Matrix with positive and negative flows (PROMETHEE I) and net flows for
complete ranking (PROMETHEE II).

-\code{NFC} Net flows matrix by criterion.
}
\description{
PROMETHEE is a multicriteria method that quantifies preference relationships
and obtains the positive, negative and net flows of the alternatives,
generating rankings that reflect the decision-maker's preferences. This
function applies PROMETHEE I (partial ranking) and PROMETHEE II (full ranking).
This function can handle a large number of alternatives.
}
\details{
\itemize{
\item The types of preference function are as follows: "linear", "v-shape",
"usual", "u-shape", "level" and "gaussian".
\item The preference and indifference thresholds depend on the type of function
selected. The preference threshold requires definition (is non-zero) for all
functions except for "usual" and "u-shaped". The indifference threshold is
non-zero for "linear", "level" and "u-shaped" functions.
\item In the objective write "max" to maximize or "min" to minimize.
\item The sum of the weights of all criteria must be equal to 1.
\item This implementation of \code{PROMETHEEII} is designed to handle a large number
of alternatives (it has been tested with 10,000 alternatives) much higher
than the previous implementations in R (\code{promethee123} and \code{PROMETHEE}).
}
}
\examples{
matrix_evaluation <- data.frame (

Alternative = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
                11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
                21, 22, 23, 24, 25, 26, 27, 28, 29, 30),
Monetary = c(21.52, 68.09, 184.94, 237.62, 14.29, 12.78, 91.53, 11.39, 264.79,12.74,
            274.41, 3.75, 47.92, 34.5, 45.89, 39.92, 31.18, 273.23, 16.39, 3.91,
            20.09, 6.52, 26.62, 28.47, 7.57, 69.2, 420.95, 12.01, 85.88, 8.78),
Recency = c(0, 0, 0, 0, 3, 5, 0, 6, 0, 3,
           1, 0, 1, 0, 0, 0, 0, 0, 2, 1,
           0, 0, 0, 0, 5, 1, 0, 0, 1, 4),
Frequency = c(7, 5, 12, 12, 1, 3, 9, 2, 12, 4,
             11, 3, 10, 10, 11, 11, 12, 12, 7, 1,
             5, 2, 9, 11, 4, 10, 12, 3, 10, 2),
Financial_score = c(66, 58, 83, 68, 68, 69, 77, 55, 77, 53,
                   78, 35, 84, 75, 71, 64, 56, 55, 52, 30,
                   66, 50, 65, 53, 54, 82, 68, 53, 62, 43),
Length = c(4, 3, 3, 2, 2, 2, 2, 3, 2, 4,
          3, 3, 1, 1, 2, 5, 4, 2, 2, 5,
          4, 5, 1, 4, 2, 1, 5, 1, 1, 2))
data_criteria <- data.frame(
Parameter = c("Function Type", "Indifference Threshold",
             "Preference Threshold","Objetive", "Weight"),
Frequency = c("linear", 0, 3, "max", 0.2),
Monetary = c("linear", 30.00, 120, "max", 0.4),
Recency = c("usual", 0.00, 0.00, "min", 0.1),
Financial_score = c("linear", 0.00, 10, "max", 0.2),
Length = c("usual", 0.00, 0.00, "max", 0.1))
RS <- PROMETHEEII(matrix_evaluation, data_criteria)
RS$NF
RS$NFC
}
\references{
Brans, J.P.; De Smet, Y., (2016). PROMETHEE Methods. In: Multiple Criteria
Decision Analysis. State of the Art Surveys, Figuera, J., Greco, S.,
Ehrgott, M.; Springer: New York, USA, pp. 187-219. DOI: 10.1007/978-1-4939-3094-4_6.
}
