% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{list_studies}
\alias{list_studies}
\title{Get the List of Studies in the Current Active Trial}
\usage{
list_studies()
}
\value{
A data frame containing study names and associated location names. If no studies are available, an error is thrown.
}
\description{
Retrieves a list of studies (and associated locations) for the currently active trial, as configured 
using the \code{\link{set_trial}} function.
}
\note{
This function must be called after a trial has been set using \code{\link{set_trial}}.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()  # Log in to the server
  set_crop("wheat")  # Set crop
  set_program("Wheat International Nurseries")  # Set breeding program
  set_trial("IDYT39")  # Set trial
  list_studies()  # List studies
}

}
\seealso{
\code{\link{login}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{set_trial}} for related operations on crops, programs, and trials.
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
