% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/QFRM.R
\name{BS_Simple}
\alias{BS_Simple}
\title{Black-Scholes formula}
\usage{
BS_Simple(S0 = 42, K = 40, r = 0.1, q = 0, ttm = 0.5, vol = 0.2)
}
\arguments{
\item{S0}{The spot price of the underlying security}

\item{K}{The srike price of the underlying (same currency as S0)}

\item{r}{The annualized risk free interest rate, as annual percent / 100
(i.e. fractional form. 0.1 is 10 percent per annum)}

\item{q}{The annualized dividiend yield, same units as \code{r}}

\item{ttm,}{The time to maturity, fraction of a year (annualized)}

\item{vol}{The volatility, in units of standard deviation.}
}
\value{
a list of BS formula elements and BS price,
such as \code{d1} for \eqn{d_1}, \code{d2} for \eqn{d_2}, \code{Nd1} for \eqn{N(d_1)},
\code{Nd2} for \eqn{N(d_2)}, N\code{CallPxBS} for BSM call price, \code{PutPxBS} for BSM put price
}
\description{
Black-Scholes (aka Black-Scholes-Merton, BS, BSM) formula for simple parameters
}
\details{
Uses BS formula to calculate call/put option values and elements of BS model
}
\examples{
#See Hull p.339, Ex.15.6.
(o <- BS_Simple(S0=42,K=40,r=.1,q=0,ttm=.5,vol=.2))$Px$Call #returns 4.759422
o$Px$Put # returns 0.8085994 as the price of the put

BS_Simple(100,90,0.05,0,2,0.30)
BS_Simple(50,60,0.1,.2,3,0.25)
BS_Simple(90,90,0.15,0,.5,0.20)
BS_Simple(15,15,.01,0.0,0.5,.5)
}
\author{
Robert Abramov, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, J.C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod}. \url{http://amzn.com/0133456315}
\url{http://www.theresearchkitchen.com/archives/106}
}

