% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Barrier.R
\name{BarrierLT}
\alias{BarrierLT}
\title{Barrrier option valuation via lattice tree (LT)}
\usage{
BarrierLT(o = OptPx(Opt(Style = "Barrier"), vol = 0.25, r = 0.05, q = 0.02,
  NSteps = 5), dir = c("Up", "Down"), knock = c("In", "Out"), H = 60)
}
\arguments{
\item{o}{An object of class \code{OptPx}}

\item{dir}{A direction for the barrier, either \code{'Up'} or \code{'Down'} Default=\code{'Up'}}

\item{knock}{The option is either a knock-in option or knock-out option. Default=\code{'In'}}

\item{H}{The barrier level. \code{H} should less than \code{S0} if \code{'Up'},
\code{H} should greater than \code{S0} if \code{'Down'} Default=60.}
}
\value{
A list of class \code{BarrierLT} consisting of the input object \code{OptPx}
and the appended new parameters and option price.
}
\description{
Use Binomial Tree to price barrier options with relatively large NSteps (NSteps > 100) steps.
             The price may be not as percise as BSM function cause the convergence speed for Binomial Tree is kind of slow.
}
\examples{
# default Up and Knock-in Call Option with H=60, approximately 7.09
(o = BarrierLT())$PxLT

#Visualization of price changes as Nsteps change.
o = Opt(Style="Barrier")
visual=sapply(10:200,function(n) BarrierLT(OptPx(o,NSteps=n))$PxLT)

c=(10:200)
plot(visual~c,type="l",xlab="NSteps",ylab="Price",main="Price converence with NSteps")

# Down and Knock-out Call Option with H=40
o = OptPx(o=Opt(Style="Barrier"))
BarrierLT(o,dir="Down",knock="Out",H=40)

# Down and Knock-in Call Option with H=40
o = OptPx(o=Opt(Style="Barrier"))
BarrierLT(o,dir="Down",knock="In",H=40)

# Up and Knock-out Call Option with H=60
o = OptPx(o=Opt(Style="Barrier"))
BarrierLT(o,dir='Up',knock="Out")

# Down and Knock-out Put Option with H=40
o = OptPx(o=Opt(Style="Barrier",Right="Put"))
BarrierLT(o,dir="Down",knock="Out",H=40)

# Down and Knock-in Put Option with H=40
o = OptPx(o=Opt(Style="Barrier",Right="Put"))
BarrierLT(o,dir="Down",knock="In",H=40)

# Up and Knock-out Put Option with H=60
o = OptPx(o=Opt(Style="Barrier",Right="Put"))
BarrierLT(o,dir='Up',knock="Out")

# Up and Knock-in Put Option with H=60
BarrierLT(OptPx(o=Opt(Style="Barrier",Right="Put")))
}
\author{
Tong Liu, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
 ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}
\cr p.467-468. Trinomial Trees, p.604-606: Barrier Options.
}

