% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Compound.R
\name{CompoundLT}
\alias{CompoundLT}
\title{Compound option valuation via lattice tree (LT) model}
\usage{
CompoundLT(o1 = OptPx(Opt(Style = "Compound")), o2 = OptPx(Opt(Style =
  "Compound")))
}
\arguments{
\item{o1}{The \code{OptPx} object with the shorter time to maturity}

\item{o2}{The \code{OptPx} object with the longer time to maturity}
}
\value{
User-supplied \code{o1} option with fields \code{o2} and \code{PxLT},
as the second option and calculated price, respectively.
}
\description{
\code{CompoundLT} prices a compound option using the binomial tree (BT) method.
The inputs it takes are two \code{OptPx} objects.
It pulls the S from the o2 input which should be the option with the greater time to maturity.
}
\examples{
(o = CompoundLT())$PxLT # Uses default arguments

#Put option on a Call:
o = Opt(Style="Compound", S0=50, ttm=.5, Right="P", K = 50)
o1 = OptPx(o, r = .1, vol = .4, NSteps = 5)
o = Opt(Style="Compound", S0=50, ttm=.75, Right="C", K = 60)
o2 = OptPx(o, r = .1, vol = .4, NSteps = 5)
(o = CompoundLT(o1, o2))$PxLT

#Call option on a Call:
o = Opt(Style = "Compound", S0 = 50, ttm= .5, Right = "Call", K = 50)
o1 = OptPx(o, r = .1, vol = .4, NSteps = 5)
o = Opt(Style = "Compound", S0 = 50, ttm= .75, Right = "Call", K = 5)
o2 = OptPx(o, r = .1, vol = .4, NSteps = 5)
(o = CompoundLT(o1, o2))$PxLT

#Put option on a Put:
o = Opt(Style = "Compound", S0 = 50, ttm= .5, Right = "Put", K = 40)
o1 = OptPx(o, r = .1, vol = .4, NSteps = 5)
o = Opt(Style = "Compound", S0 = 50, ttm= .75, Right = "Put", K = 50)
o2 = OptPx(o, r = .1, vol = .4, NSteps = 5)
(o = CompoundLT(o1, o2))$PxMC

#Call option on a Put:
o = Opt(Style = "Compound", S0 = 50, ttm= .5, Right = "Call", K = 30)
o1 = OptPx(o, r = .1, vol = .4, NSteps = 5)
o = Opt(Style = "Compound", S0 = 50, ttm= .75, Right = "Put", K = 80)
o2 = OptPx(o, r = .1, vol = .4, NSteps = 5)
(o = CompoundLT(o1, o2))$PxLT
}
\author{
Kiryl Novikau, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}.
}

