% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Ladder.R
\name{LadderMC}
\alias{LadderMC}
\title{Ladder option valuation via Monte Carlo (MC) simulation.}
\usage{
LadderMC(o = OptPx(o = Opt(Style = "Ladder"), NSteps = 5), NPaths = 5,
  L = c(60, 80, 100))
}
\arguments{
\item{o}{The \code{OptPx} Ladder option object to price.}

\item{NPaths}{The number of simulation paths to use in calculating the price}

\item{L}{A series of ladder strike price.}
}
\value{
The option \code{o} with the price in the field \code{PxMC} based on MC simulations
   and the ladder strike price \code{L} set by the users themselves
}
\description{
Calculates the price of a Ladder Option using 5000 Monte Carlo simulations.
The helper function LadderCal() aims to calculate expected payout for each stock prices.

\emph{Important Assumptions}:
The option o follows a General Brownian Motion (BM)
\eqn{ds = mu * S * dt + sqrt(vol) * S * dW} where \eqn{dW ~ N(0,1)}.
The value of \eqn{mu} (the expected price increase) is assumed to be \code{o$r}, the risk free rate of return.
}
\examples{
(o = LadderMC())$PxMC #Price = ~12.30

 o = OptPx(o=Opt(Style='Ladder'), NSteps = 5)
 (o = LadderMC(o))$PxMC        #Price = ~11.50

 o = OptPx(Opt(Style='Ladder', Right='Put'))
 (o = LadderMC(o, NPaths = 5))$PxMC   # Price = ~12.36

 (o = LadderMC(L=c(55,65,75)))$PxMC   # Price = ~10.25
}
\author{
Huang Jiayao, Risk Management and Business Intelligence at Hong Kong University of Science and Technology,
         Exchange student at Rice University, Spring 2015
}
\references{
\url{http://stackoverflow.com/questions/25946852/r-monte-carlo-simulation-price-path-converging-volatility-issue}
}

